/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yJpH
 */

package {
    import flash.display.Sprite;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    
    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=60)]
    
    public class FlashTest extends Sprite {
        
        public function FlashTest() {
            var timer = new Timer(100);
            timer.start();
            timer.addEventListener(TimerEvent.TIMER, xDown);
            
            function xDown(e:TimerEvent):void {
                for(var i:Number=0; i<3; i++) {
                    var mySprite:Sprite = makeSprite();
                    drowSprite(mySprite);
                }
            }
            
            function makeSprite():Sprite {
                var mySprite:Sprite = new Sprite();
                mySprite.x = Math.floor(Math.random()*stage.stageWidth);
                mySprite.y = Math.floor(Math.random()*stage.stageHeight);
                var px:Number = Math.floor(Math.random()*stage.stageWidth);
                var py:Number = Math.floor(Math.random()*stage.stageHeight);
                var myColor:ColorTransform = new ColorTransform();
                myColor.color = Math.floor(Math.random()*0xffffff);
                mySprite.transform.colorTransform = myColor;
                addChild(mySprite);
                mySprite.addEventListener(Event.ENTER_FRAME, xMove);
                
                function xMove(e:Event):void {
                    mySprite.x += (px - mySprite.x)/80;
                    mySprite.y += (py - mySprite.y)/80;
                    
                    var dx = py-mySprite.y;
                    
                    if(Math.abs(dx) < 10) {
                        mySprite.alpha-=0.05;
                        if(mySprite.alpha < 0) {
                            mySprite.graphics.clear();
                            mySprite.removeEventListener(Event.ENTER_FRAME, xMove);
                            removeChild(mySprite);
                        }
                    }
                }
                return mySprite;
            }
            
            function drowSprite(mySprite:Sprite):void {
                mySprite.graphics.beginFill(0xcccccc, 1);
                mySprite.graphics.drawRect(0,0,1,10);
            }            
        }
    }
}