/**
 * Copyright Hasufel ( http://wonderfl.net/user/Hasufel )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yJ6I
 */

// forked from undo's 高速化　forked from: 止まったらハジケる玉
// forked from undo's 止まったらハジケる玉
// @Hasufel: HSV variation + Vectors

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0)]

    public class FlashTest extends Sprite {
        private const _stageW:uint = stage.stageWidth;
        private const _stageH:uint = stage.stageHeight;
        private var _balls:Vector.<Ball> = new Vector.<Ball>;
        private var _grv:Number = 1;
        private var _bounce:Number = .5;
        private var _limitSpeed:Number = 1;
        private var _minRadius:Number = 5;
        private var _splitNum:uint = 4;
        private var _cc:uint = 0;
        private var _bmp:Bitmap;
        private var _bmd:BitmapData;
        private var _bmdRect:Rectangle = new Rectangle(0,0,_stageW,_stageH);

        public function FlashTest(){
            init();
        }

        private function init():void{
            // write as3 code here..
            Wonderfl.capture_delay(10);
            addEventListener(Event.ADDED_TO_STAGE, onAdded);
        }

        private function onAdded(evt:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, onAdded);
            _bmd = new BitmapData(_stageW, _stageH, false, 0x00000000);
            _bmp = new Bitmap(_bmd);
            addChild(_bmp);
               
            var mouth:Sprite = addChild(new Sprite()) as Sprite;
            mouth.graphics.lineStyle(2,0xffffff,1);
            mouth.graphics.moveTo(180,300);
            mouth.graphics.curveTo(200,330,233,305);
            mouth.graphics.moveTo(285,300);
            mouth.graphics.curveTo(265,330,233,305);

            makeFirstBall();

            addEventListener(Event.ENTER_FRAME, onEnter);
        }

        private function makeFirstBall():void {
            var c:uint = hsv2rgb(_cc/2,1,.9);
            var c2:uint = hsv2rgb(_cc/2,1,.7);
            var b:Ball = new Ball(50, Math.random() * 10 - 5, 0, c, c2);
            b.x = int(_stageW / 2);
            b.y = int(_stageW / 2);
            _balls.push(b);
        }

        private function onEnter(evt:Event):void {
            _bmd.lock();
            _bmd.fillRect(_bmdRect,0x00000000);
            
            var l:uint = _balls.length;
            for(var i:int = l - 1; i >= 0; i--) {
                var b:Ball = _balls[i] as Ball;
                var bounced:Boolean = false;
                b.vy += _grv;
                b.x += b.vx;
                b.y += b.vy;
                if(b.x + b.r > _stageW || b.x - b.r < 0){
                    b.x -= b.vx;
                    b.vx *= -_bounce;
                    b.vy *= _bounce;
                    bounced = true;
                }
                if(b.y + b.r > _stageH || b.y - b.r < 0){
                    b.y -= b.vy;
                    b.vx *= _bounce;
                    b.vy *= -_bounce;
                    bounced = true;
                }
                if(bounced && Math.abs(b.vx)+Math.abs(b.vy) < _limitSpeed){
                    _balls.splice(i, 1);
                    if(b.r > _minRadius){
                        _cc = (++_cc)%720;
                        var c:uint = hsv2rgb(_cc/2,.5,.9);
                        var c2:uint = hsv2rgb(_cc/2,.7,.7);
                        for(var j:uint = 0; j < _splitNum; ++j) {
                            var b1:Ball = new Ball(b.r * .7, Math.random() * 100 - 50, Math.random() * 100, c, c2);
                            b1.x = b.x;
                            b1.y = b.y;
                            _balls.push(b1);
                        }
                    }
                    else if(_balls.length == 0){
                        makeFirstBall();
                    }
                    b = null;
                }
                else {
                    _bmd.copyPixels(b.bmd, b.bmd.rect, new Point(b.x-b.r,b.y-b.r),null,null,true);
                }
            }
            _bmd.unlock();
        }

       private function hsv2rgb(h:Number,s:Number,v:Number):uint{
            var i:int = int(h/60);
            var f:Number = h/60-i;
            var p:Number = v*(1-s);
            var q:Number = v*(1-s*f);
            var t:Number = v*(1-s*(1-f));
            switch (i) {
                case 0: return v * 0xFF << 16 | t * 0xFF << 8 | p * 0xFF << 0;
                case 1: return q * 0xFF << 16 | v * 0xFF << 8 | p * 0xFF << 0;
                case 2: return p * 0xFF << 16 | v * 0xFF << 8 | t * 0xFF << 0;
                case 3: return p * 0xFF << 16 | q * 0xFF << 8 | v * 0xFF << 0;
                case 4: return t * 0xFF << 16 | p * 0xFF << 8 | v * 0xFF << 0;
                case 5: return v * 0xFF << 16 | p * 0xFF << 8 | q * 0xFF << 0;
            }
            return 0;
        }

    }
}

import flash.display.BitmapData;
import flash.display.Sprite;

class Ball{
    public var r:Number;
    public var vx:Number;
    public var vy:Number;
    public var x:Number = 0;
    public var y:Number = 0;
    public var bmd:BitmapData;
    public var col:uint;
    public var col2:uint;

    public function Ball(rad:Number = 100, vx:Number = 0, vy:Number = 0, color:uint = 0xffff0000, color2:uint = 0xffff0000){
        r = rad;
        col = color;
        col2 = color2;
        bmd = new BitmapData(r*2,r*2,true,0x00000000);
        var s:Sprite = new Sprite();
            s.graphics.beginFill(col);
            s.graphics.drawCircle(r,r,r);
            s.graphics.endFill();
            s.graphics.beginFill(col2);
            s.graphics.drawCircle(r,r,5*r/8);
            s.graphics.endFill();
            s.graphics.beginFill(0xffffff);
            s.graphics.drawCircle(5*r/4,r/2,r/4);
            s.graphics.endFill();
        bmd.draw(s);
        this.vx = vx;
        this.vy = vy;
    }
}