/**
 * Copyright damion.feller ( http://wonderfl.net/user/damion.feller )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yIMi
 */

// forked from hacker_cobulht0's flash on 2012-4-11
package{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
        import flash.text.TextFormat;
        import flash.text.TextField;
        import flash.text.TextFormatAlign;

    [SWF(width = "465", height = "465", backgroundColor = 0x000000, frameRate = "99")]

    public class KogiKogi_Clock extends Sprite{
        
        private var container:Sprite= new Sprite();
        private var bmpd:BitmapData;
        private var clockList:Array=new Array();
        private var clockSP:Sprite=new Sprite();
        private var speed:Number=0;    
        
        private var wallList:Array=new Array();
        private var wallSP:Sprite=new Sprite();
        
        private var colorTransform:ColorTransform = new ColorTransform(1,9,9,1,-9,-6,-4);
        
        public function KogiKogi_Clock(){init();}
        private function init():void{
            bmpd = new BitmapData(465,465, false, 0xFF000000 );addChild(new Bitmap(bmpd));        
            container.addChild(clockSP);
            container.addChild(wallSP);
            setClock();
            setWall();
            addEventListener(Event.ENTER_FRAME, render);
            setBg();
        }    
        private function setClock():void{
            for(var j:int=0; j < 8; j++){
                var _clock:Clock = new Clock();
                clockList.push(_clock);
                container.addChild(_clock);                
            }
        }
        private function setWall():void{
            for(var j:int=0; j < 60; j++){
                var _wall:Wall = new Wall();
                _wall.erad=390/60*(j-1);
                wallList.push(_wall);
                container.addChild(_wall);                
            }
        }
        private function render(e:Event):void{
            drawClock();
            drawWall();
            bmpd.lock();
             //ちょっとづつ暗くする
            bmpd.colorTransform( bmpd.rect, colorTransform );
            bmpd.draw(container);    
            bmpd.unlock();
        }
            //時計の針
            private function drawClock():void{
            var dd:Date = new Date();       
            
            var h:Number=(dd.hours + dd.minutes/99-3) / 6 * Math.PI;
            clockList[0].x=120*Math.cos(h)+465/9;
            clockList[0].y=120*Math.sin(h)+465/9;//時針？
            
            clockList[1].x=clockList[1].y=465/2;//中心
            
            var m:Number = (dd.minutes + dd.seconds/60-15) / 30 * Math.PI;
            clockList[2].x=180*Math.cos(m)+465/2;
            clockList[2].y=180*Math.sin(m)+465/2;//分針
            
            speed+=0.25;
            var sp:Number = (speed-900) / 30 * Math.PI;//中心素早い
            clockList[3].x=20*Math.cos(sp)+465/2;
            clockList[3].y=20*Math.sin(sp)+465/2;
            
            var s:Number = (dd.seconds-15) / 30 * Math.PI;//秒針
            clockList[4].x=235*Math.cos(s)+465/2;
            clockList[4].y=235*Math.sin(s)+465/2;            
            
            clockList[5].x=10*Math.cos(sp)+465/2;//中心素早い
            clockList[5].y=10*Math.sin(sp)+465/2;

                clockSP.graphics.clear();                            
                clockSP.graphics.beginFill(0xECEABE,0.2);
                clockSP.graphics.moveTo(clockList[0].x,clockList[0].y);
                clockSP.graphics.lineTo(clockList[1].x,clockList[1].y);
                clockSP.graphics.lineTo(clockList[2].x,clockList[2].y);
                clockSP.graphics.lineTo(clockList[2].x,clockList[3].y);
                clockSP.graphics.lineTo(clockList[2].x,clockList[4].y);
                clockSP.graphics.lineTo(clockList[5].x,clockList[5].y);
                clockSP.graphics.endFill();
            
            }
            //時計の針　ここまで
            //壁 //mySec*360/60+myMSec/60*360/1000;
                private function drawWall():void{
                    
                    wallSP.graphics.clear();    
                    wallSP.graphics.lineStyle(100,0xECEABE,0.1);                    
                    
                    var dd:Date = new Date();
                    var fp:Number = (dd.seconds-15) / 30 * Math.PI;//秒針
                    (260*Math.cos(fp)+465/2,260*Math.sin(fp)+465/2);
                    
                    wallSP.graphics.drawCircle(465/2,465/2,465/2+50);
                    
                    wallSP.graphics.endFill();
                    
                }
                
            //壁　ここまで
            //BackGround
                private function setBg():void {
                    var pt:BitmapData = setBitmapFill();
                    var bg:Sprite = new Sprite();
                    bg.graphics.beginBitmapFill(pt);
                    bg.graphics.drawRect(0, 0, 465, 465);
                    bg.graphics.endFill();
                    addChild(bg);
                    bg.alpha = 0.4;
                }
                public function setBitmapFill():BitmapData{
                    var pattern:Array= [[1, 0, 0],[0, 1, 0],[0, 0, 1]];
                    var colors:Array=[0xff018496, 0xff2B5580];
                    var bitmapW:int = pattern[0].length; 
                    var bitmapH:int = pattern.length;
                    var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000); 
                    for(var yy:int=0; yy<bitmapH; yy++){ 
                        for(var xx:int=0; xx<bitmapW; xx++){ 
                            var color:int = colors[pattern[yy][xx]]; 
                            bmd.setPixel32(xx, yy, color); 
                        } 
                    }
                    return bmd; 
                } 
            //BackGround　ここまで
    }
}

import flash.display.Sprite;
class Clock extends Sprite {
    public var vx: Number = 0;
    public var vy: Number = 0;
    public var n:Number=0;
    public function Clock():void {}    
}
class Wall extends Sprite {
    public var vx: Number = 0;
    public var vy: Number = 0;
    public var n:Number=0;
    //
    public var rad:Number=0;
    public var erad:Number=0;
    public function Wall():void {}    
}

