/**
 * Copyright mchang ( http://wonderfl.net/user/mchang )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yII4
 */

// forked from checkmate's Saqoosha challenge for amateurs
// 画像をマウスオーバーしてください
//
// 画像のURL
// http://www.iconarchive.com/category/animals/delightful-zodiac-icons-by-troyboydesign.html
//
// おっ、虹が出トラッ
// ほんとだっへっびっ
// 虹さんすぐ消えちゃうだブー
package
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;

	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;

	import net.hires.debug.Stats;

	[SWF(width="465", height="465", backgroundColor="#000000", frameRate="60")]
	
	public class Rainbow extends Sprite
	{
		private var _canvas:BitmapData;
		private var _point:Point;
		private var _filter:BlurFilter;
		private var _loader:Loader;
		private var _particles:Array;	
		private var _animalSprite:Sprite;
		private var _animal:BitmapData;
		private var _backRainbow:BackRainbow;

		public function Rainbow()
		{
			addEventListener(Event.ADDED_TO_STAGE, initialize);
		}
		
		private function initialize(e:Event):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, initialize);
			
			// Stage の設定
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;

			// 初期化
			_animalSprite = new Sprite();
			_point = new Point();
			_filter = new BlurFilter();
			_particles = new Array();

			// 画像ロード
			_loader = new Loader();
			_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, tigerImageCompleteHandler);
			_loader.load(new URLRequest('http://wonderfl.minaco.net/Tiger-128x128.png'), new LoaderContext(true)); 
		}
		
		private function tigerImageCompleteHandler(e:Event):void
		{	
			var bmp:Bitmap = new Bitmap();
			bmp = Bitmap(_loader.contentLoaderInfo.content);
			bmp.x = 40;
			bmp.y = 300;
			_animalSprite.addChild(bmp);
			
			// 画像ロード
			_loader = new Loader();
			_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, snakeImageCompleteHandler);
			_loader.load(new URLRequest('http://wonderfl.minaco.net/Snake-128x128.png'), new LoaderContext(true)); 
		} 
		
		private function snakeImageCompleteHandler(e:Event):void
		{
			var bmp:Bitmap = new Bitmap();
			bmp = Bitmap(_loader.contentLoaderInfo.content);
			bmp.x = 168;
			bmp.y = 300;
			_animalSprite.addChild(bmp);	
			
			// 画像ロード
			_loader = new Loader();
			_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, pigImageCompleteHandler);
			_loader.load(new URLRequest('http://wonderfl.minaco.net/Pig-128x128.png'), new LoaderContext(true)); 
		} 

		private function pigImageCompleteHandler(e:Event):void
		{	
			var bmp:Bitmap = new Bitmap();
			bmp = Bitmap(_loader.contentLoaderInfo.content);
			bmp.x = 296;
			bmp.y = 300;
			_animalSprite.addChild(bmp);	

			// 背景を表示させる
			_backRainbow = new BackRainbow(stage.stageWidth, stage.stageHeight);
			_backRainbow.x = 0;
			_backRainbow.y = 340;
			addChild(_backRainbow);

			// 動物を表示させる BitmapData
			var rectangle:Rectangle = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight); 
			var matrix:Matrix = new Matrix(); 
			matrix.translate(0, 0);
	
			_animal = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x000000);
			_animal.draw(_animalSprite, matrix, null, null, rectangle);
			addChild(new Bitmap(_animal)) as Bitmap;

			// 虹の粒を表示させる BitmapData
			_canvas = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x000000);	
			addChild(new Bitmap(_canvas));

			// Stats
			//addChild(new Stats());

			addEventListener(Event.ENTER_FRAME, update);
		}


		private function update(e:Event):void
		{
			var color:Number = _animal.getPixel(stage.mouseX, stage.mouseY);

			// 虹の粒をつくる
			if (color != 0) {
				_particles.push(new RainbowParticle(stage.stageWidth, stage.stageHeight, color));
			}

			// 虹の粒が存在しなかった場合、背景を黒にする。存在したら、背景をグラデーションで表示する
			if (_particles.length == 0) {
				_backRainbow.update(0);
			} else {
				if (color != 0) {
					_backRainbow.update(color);
				}
			}

			_canvas.lock();
			_canvas.fillRect(_canvas.rect, 0);

			var p:RainbowParticle;
			var matrix:Matrix;
			for each (p in _particles) {	
				if (p.deleteFlag == true) {
					_particles.splice(_particles.indexOf(p), 1);
				} else {
					p.update();
				}
				matrix = new Matrix();
				matrix.translate(p.x, p.y);
				_canvas.draw(p, matrix, new ColorTransform());

			}
			_canvas.applyFilter(_canvas, _canvas.rect, _point, _filter);
			_canvas.unlock();
		}
	}
}

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;
import flash.display.BitmapData;

import frocessing.color.ColorLerp;
import frocessing.color.FColor;

import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.*;

class RainbowParticle extends Sprite
{
	public var deleteFlag:Boolean = false;

	private var _grad:Gradation;
	private var _gradColor:Array;

	private var _stageWidth:Number;
	private var _stageHeight:Number;

	private var _color:uint;

	private var _v:Number;
	private var _radius:Number;
	private var _angle:Number;
	
	private var _circleRadius:Number;
	private var _circleAlpha:Number = 1;

	private var _count:uint = 0;

	public function RainbowParticle(stageWidth:Number, stageHeight:Number, color:uint):void
	{
		_stageWidth = stageWidth;
		_stageHeight = stageHeight;
		_color = color;

		// 今の色から彩度を変えてグラデーションをつくる
		var hsv:Object = FColor.ValueToHSV(_color);	

		_gradColor = new Array();
		_gradColor.push(FColor.HSVtoValue(hsv.h, hsv.s, hsv.v));

		var diff:Number = Math.round(hsv.s / 5 * 100) / 100;
		var value:uint;
		for (var i:uint=1; i<=4; i++) {
			value = FColor.HSVtoValue(hsv.h, hsv.s-(i*diff), hsv.v);
			_gradColor.push(value);
		}
		_gradColor.push(FColor.HSVtoValue(hsv.h, 0, hsv.v));

		_grad = new Gradation(
			_gradColor[0],
			_gradColor[1],
			_gradColor[2],
			_gradColor[3],
			_gradColor[4],
			_gradColor[5]
		);
		_grad.setEasing(Circ.easeInOut);

		// 速度
		_v = Math.random() - 0.5;

		// 表示する円の半径
		_circleRadius = Math.random() * 10;

		// 配置する場所の半径
		_radius = Math.random() * 30 + 230;

		// 角度(180〜360度の間)
		_angle = Math.random() * 180 + 180;
		
		x = Math.cos(_angle * Math.PI/180) * _radius + _stageWidth / 2;
		y = Math.sin(_angle * Math.PI/180) * _radius + (_stageHeight / 2 + 100);
	}
	
	public function update():void
	{
		// 表示
		graphics.clear();
		graphics.beginFill(_grad.getColor(_count/100), _circleAlpha);
		graphics.drawCircle(0, 0, _circleRadius);
		graphics.endFill();

		// 移動
		_angle += _v;
		_radius += _v;
		x = Math.cos(_angle * Math.PI/180) * _radius + _stageWidth / 2;
		y = Math.sin(_angle * Math.PI/180) * _radius + (_stageHeight / 2 + 100);
		
		if (_count < 100) {
			_count++;
		} else {
			_circleAlpha -= 0.1;
			_circleAlpha = Math.round(_circleAlpha * 100) / 100;
			if (_circleAlpha <= 0) {
				deleteFlag = true;
			}
		}
	}
}

class BackRainbow extends Sprite
{
	private var _grad:Gradation;
	private var _gradColor:Array;

	private var _v:Number;
	private var _color:uint;
	
	private var _r:uint = 0;
	private var _g:uint = 0;
	private var _b:uint = 0;

	private var _stageWidth:Number;
	private var _stageHeight:Number;

	public function BackRainbow(stageWidth:Number, stageHeight:Number):void
	{	
		_stageWidth = stageWidth;
		_stageHeight = stageHeight;
	}
	
	public function update(color:uint=0x000000):void
	{
		// RGB で前の色と近い色を求める
		var rgb:Object = FColor.ValueToRGB(color);
		_r += (rgb.r - _r) / 8.0;
		_g += (rgb.g - _g) / 8.0;
		_b += (rgb.b - _b) / 8.0;
		_color = FColor.RGBtoValue(_r, _g, _b, 1);

		// HSV で色を取得する
		var hsv:Object = FColor.ValueToHSV(_color);
		
		// 黒以外のときは、明度を少し下げて調整
		if (color != 0) {
			hsv.v -= 0.1;
		}

		// 今の色(_color)から彩度を変えてグラデーションをつくる		
		_gradColor = new Array();
		_gradColor.push(FColor.HSVtoValue(hsv.h, hsv.s, hsv.v));

		var diff:Number = Math.round(hsv.s / 5 * 100) / 100;
		var value:uint;
		for (var i:uint=1; i<=4; i++) {
			value = FColor.HSVtoValue(hsv.h, hsv.s-(i*diff), hsv.v);
			_gradColor.push(value);
		}
		_gradColor.push(FColor.HSVtoValue(hsv.h, 0, hsv.v));

		_grad = new Gradation(
			_gradColor[5],
			_gradColor[4],
			_gradColor[3],
			_gradColor[2],
			_gradColor[1],
			_gradColor[0]
		);
		_grad.setEasing(Circ.easeInOut);		

		// 背景つくる
		graphics.clear();
		for (var j:uint = 0; j < 125; j++) {
			graphics.beginFill(_grad.getColor(j/125));
			graphics.drawRect(0, j, _stageWidth, 1);
			graphics.endFill();
		}
	}
}


class Gradation {
    
    private var _colors:Array;
    private var _easing:IEasing;
    
    public function Gradation(...args) {
        _colors = args.concat();
        _easing = Linear.linear;
    }
    
    public function setEasing(easing:IEasing):void {
        _easing = easing;
    }
    
    public function getColor(position:Number):uint {
        position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
        var idx:int = position;
        var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
        if (alpha == 0) {
            return _colors[idx];
        } else {
            return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
        }
    }
}