/**
 * Copyright taromisako ( http://wonderfl.net/user/taromisako )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yIH0
 */

// forked from taromisako's 透明な矩形をBitmapDataで描画してみる。
package {
	import flash.text.TextField;
	
    import flash.display.Sprite;
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.utils.*;
    import flash.geom.*;
    import net.hires.debug.Stats;
    
    [SWF(frameRate="60", width="465", height="465")]
    
    public class FlashTest extends Sprite {
    		
    		// オブジェクトの数
        private var num:int = 1000;
        
        private var _circle:Sprite = new Sprite;
    		
    		private var circle_x:Array = new Array();
    		private var circle_y:Array = new Array();
    		private var circle_vy:Array = new Array();
    		
    		// 表示用の透明なBitmapData
		private var bitmapData:BitmapData = new BitmapData(465, 465, true, 0x00000000); 
		
		private var bitmap:Bitmap = new Bitmap();
    		
    		private var parts:BitmapData = new BitmapData(50, 50, true, 0x00000000);	
    		
        public function FlashTest() {    
			
			// 塗り_fillColor, 半径_radiusの円
	        _circle.graphics.beginFill(0x000000, 0.2);
	        _circle.graphics.drawCircle(0, 0, 10); 
	        _circle.graphics.endFill();
	        _circle.alpha = 0;
	        
	        var matrix:Matrix = new Matrix();
			matrix.translate(10, 10); 
			parts.draw(_circle, matrix); 
	        
			// 配置する
			stage.addChild(bitmap);
			
			// 円の位置を初期化
			for(var i:int=0; i<num; i++) {                
               Init(i);
            }
			
			// Statsを表示
            addChild(new Stats());
			
			// イベントリスナー（昔はメインループって呼んでたなあ…）   
            addEventListener(Event.ENTER_FRAME, draw);
                    
        }
        
        // フレーム毎に行われる処理
        private function draw(e:Event):void {
           
           	Move();
           
           	// 画面を消去
           	bitmapData.fillRect(new Rectangle(0, 0, 465, 465), 0x00000000);
           	        
			var rect:Rectangle = new Rectangle(0, 0, 20, 20);
			 
			for(var i:int=0; i<num; i++) {                
               var point:Point = new Point(circle_x[i], circle_y[i]);
               bitmapData.copyPixels(parts, rect, point, null, null, true);
            }
					
			// bitmapDataをbitmapに反映
			bitmap.bitmapData = bitmapData; 
                
        }
               
        private function Move():void {
        		
        		for(var i:int=0; i<num; i++) {
        			                
               	circle_y[i] += circle_vy[i]; 
               	
               	if(circle_y[i] > 465) {
					Init(i);  
		    		}
		    		
            }
	        
        }
        
        private function Init(i:int):void {
        		
        		circle_vy[i] = Math.ceil(Math.random() * 20);
	    		circle_x[i] = Math.floor(Math.random() * 465);	
	    		circle_y[i] = 0;	    	
	        
        }
        
    }
}