/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yI6D
 */

package {
	import com.bit101.components.CheckBox;
	import com.bit101.components.ColorChooser;
	import com.bit101.components.Label;
	import com.bit101.components.PushButton;
	import com.bit101.components.TextArea;
    import flash.display.Sprite;
	import flash.events.Event;
    public class TextToDivTable extends Sprite {
		
		private var input:TextArea;
		private var convert:PushButton;
		private var output:TextArea;
		private var text:Label;
		
		private var center:CheckBox;
		private var background:CheckBox;
		private var border:CheckBox;
		private var color1:ColorChooser;
		private var color2:ColorChooser;
		
        public function TextToDivTable() {
            
			if ( stage ) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
        }
		
		private function init(e:Event = null):void 
		{
			var sw:int = stage.stageWidth;
			var sh:int = stage.stageHeight;
			
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			input = new TextArea(this, 5, 5, "0.5 , 0 , 4 , 4 , 0.5 , 0 , 1\n\
1 , 0 , 2 , 2 , 1 , 0 , 1\n\
1.5 , 0.5 , 1 , 2 , 1.5 , 0 , 1\n\
2 , 0 , 1 , 1 , 0 , 1 , 1\n\
2.5 , 2 , 0 , 1 , 0.5 , 1 , 2\n\
3 , 2 , 0 , 1 , 1 , 1 , 2\n\
3.5 , 2 , 0 , 1 , 1.5 , 1 , 2\n\
4 , 2 , 0 , 1 , 0 , 2 , 2\n\
4.5 , 2 , 0 , 1 , 0.5 , 2 , 3\n\
5 , 2 , 0 , 1 , 1 , 2 , 3\n\
5.5 , 2 , 0 , 1 , 1.5 , 2 , 3\n\
6 , 2 , 0 , 1 , 0 , 3 , 3\n\
6.5 , 2 , 0 , 1 , 0.5 , 3 , 4\n\
7 , 2 , 0 , 1 , 1 , 3 , 4\n\
7.5 , 2 , 0 , 1 , 1.5 , 3 , 4\n\
8 , 2 , 0 , 1 , 0 , 4 , 4\n\
8.5 , 2 , 0 , 1 , 0.5 , 4 , 5\n\
9 , 2 , 0 , 1 , 1 , 4 , 5\n\
9.5 , 2 , 0 , 1 , 1.5 , 4 , 5\n\
10 , 2 , 0 , 1 , 0 , 5 , 5\n\
10.5 , 2 , 0 , 1 , 0.5 , 5 , 6");
			input.setSize( sw / 2 - 10, 120 );
			
			
			
			text = new Label(this, sw / 2, 5, "Input your data in this text area and press convert to generate a div css table");
			text.draw();
			text.textField.multiline = text.textField.wordWrap = true;
			text.textField.width = sw / 2 - 10;
			
			
			
			background = new CheckBox(this, text.x, 105, "Fill BG");
			background.selected  = true;
			color1 = new ColorChooser(this, text.x + 50, 100, 0xECEABD); 
			color1.usePopup = true;
			color2 = new ColorChooser(this, text.x + 130, 100, 0xDDDACC); 
			color2.usePopup = true;
			
			border = new CheckBox(this, text.x, 85, "Border");
			border.selected = true;
			
			center = new CheckBox(this, text.x + 50, 85, "Center");
			center.selected = true;
			
			convert = new PushButton(this, 5, 130, "CONVERT", onConvert);
			convert.setSize( sw - 10, 30 );
			
			output = new TextArea(this, 5, 165);
			output.setSize( sw - 10, sh - convert.y - convert.height - 10 );	
		}
		
		private function onConvert(e:Event):void
		{
			try 
			{
					
				var result:String = "<div style='padding: 0px; margin: 0px;'>\n";
				
				var lines:Array = input.text.split("\n");
				
				var bg1:String = background.selected ? "background:#" + color1.value.toString(16).toLocaleUpperCase() + ";" : "";
				var bg2:String = background.selected ? "background:#" + color2.value.toString(16).toLocaleUpperCase() + ";" : "";
				var brdr:String = border.selected ? "border-right:2px solid black;" : "";
				
				var extraStyle:String = "";
				
				if ( center.selected ) extraStyle += "text-align:center;";
				
				extraStyle += 'padding-top:5px;padding-bottom:5px;';
				
				var l:int = String(lines[0]).split(",").length;
				var w:int = int( 100 / l);
				
				for (var ttl:int = 0; ttl < l; ttl++)
				{
					result += "\n\t<div style='font-weight:bold;" + extraStyle + (ttl < l-1?brdr:"")  
						+ "float:left;width:" + w + "%'>\n\t\t" +String.fromCharCode(65+ttl).toLocaleUpperCase() + "\n\t</div>";
				}
				
				result += "\n\n\n\n";
				
				for (var row:int = 0; row < lines.length; row++)
				{
					var data:Array = String(lines[row]).split(",");
					
					for (var col:int = 0; col < lines.length; col++)
					{
						if ( !data[col] ) continue;
						
						result += "\n\t<div style='" + extraStyle + ( row%2==0?bg1:bg2) + (col < lines.length-1?brdr:"")  
						+ "float:left;width:" + w + "%'>\n\t\t" + data[col] + "\n\t</div>";
					}
					
					result += "<p></p>";
				}
				
				
				result += "\n\n<div style='clear:both'></div>\n\n</div>";
				
				output.text = result;
			}
			catch (e:Error)
			{
				output.text = "Failed to convert. Make shure all the columns are the same size\n\
Dont forger - the column seperator is the comma char ','.";
			}
			
		}
    }
}