/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yHgE
 */

// forked from hashito's forked from: BitmapDataで配列に格納すると高速化するよ
// forked from clockmaker's 3D Flow Simulation with Field of Blur
// forked from clockmaker's 3D Flow Simulation
// forked from clockmaker's Interactive Liquid 10000
// forked from clockmaker's Liquid110000 By Vector
// forked from munegon's forked from: forked from: forked from: forked from: Liquid10000
// forked from Saqoosha's forked from: forked from: forked from: Liquid10000
// forked from nutsu's forked from: forked from: Liquid10000
// forked from nutsu's forked from: Liquid10000
// forked from zin0086's Liquid10000
package 
{
    /**
     * 矢印がいっぱいなんだけど、高速なデモ
     * 画質はディフォルトの StageQuality.HIGH で
     * 矢印 1000個
     * @author Yasu
     */
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.utils.*;
    import flash.geom.*;
    import flash.filters.*;
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF" , rate="60")]
    public class Main extends Sprite {
        private const NUM_PARTICLE:uint = 1000;
        private const H:Number = 465;
        private const W:Number = 465;
       
        private var forceMap:BitmapData = new BitmapData( W, H, false, 0x000000 );
        private var particleList:Vector.<Arrow> = new Vector.<Arrow>(NUM_PARTICLE, true);
        private var rotArr:BitmapData ;
        private var world:Sprite = new Sprite();
        private var muse:Point;

        public function Main() {
            addChild(world);
            world.addChild(new Bitmap(forceMap));
            resetFunc();
            
            
            // 矢印をプレレンダリング
            var dummy:Sprite = new Sprite();
            dummy.graphics.beginFill(0xFFFFFF, 1);
            dummy.graphics.lineStyle(1, 0x0, 1);
            dummy.graphics.moveTo(2, 4);
            dummy.graphics.lineTo(8, 4);
            dummy.graphics.lineTo(8, 0);
            dummy.graphics.lineTo(20, 7);
            dummy.graphics.lineTo(8, 14);
            dummy.graphics.lineTo(8, 10);
            dummy.graphics.lineTo(2, 10);
            dummy.graphics.lineTo(2, 4);
            
            var matrix:Matrix;
            matrix = new Matrix();
            matrix.translate( -11, -11);
            matrix.rotate(0);
            matrix.translate( 11, 11);
            rotArr = new BitmapData(22, 22, true, 0x0);
            rotArr.draw(dummy, matrix);
            
            // パーティクルを生成します
            for (var i:int = 0; i < NUM_PARTICLE; i++) {
                var px:Number = Math.random() * H;
                var py:Number = Math.random() * W;
                particleList[i] = new Arrow(px, py,W,H);
                particleList[i].bitmapData = rotArr;
                world.addChild(particleList[i]);
            }
            museinit()
            addChild(new Stats);
            addEventListener( Event.ENTER_FRAME, loop );
        }
        
        //loop
        private function loop( e:Event ):void {
            
            var len:uint = particleList.length;
            var col:Number;
            
            for (var i:uint = 0; i < len; i++) {
                var arrow:Arrow = particleList[i];
                col = forceMap.getPixel( arrow.x , arrow.y );
                arrow.update(
                      ((col & 0xff)      - 0x80 ) * .0005 ,
                      ((col >> 8 & 0xff) - 0x80 ) * .0005);
            }
        }
        
        private function museinit():void{
           stage.addEventListener(MouseEvent.MOUSE_MOVE,mouseMove);
           stage.addEventListener(MouseEvent.MOUSE_UP,mouseUp);
           stage.addEventListener(Event.MOUSE_LEAVE,mouseLeave);
           stage.addEventListener(MouseEvent.MOUSE_DOWN,mouseDown);
        }
        private var mouseDownSt:Boolean=false;
        private function mouseDown( e:MouseEvent ):void {mouseDownSt=true;}
        private function mouseUp( e:MouseEvent ):void {mouseDownSt=false;}
        private function mouseLeave( e:Event ):void {mouseDownSt=false;}
        
        private var rect:Rectangle=new Rectangle(0,0,10,10);
        private var filter:BlurFilter=new BlurFilter(4,4,10);
        private function mouseMove( e:MouseEvent ):void {
            if(mouseDownSt){
              rect.x=mouseX;
              rect.y=mouseY;
              forceMap.setPixel(mouseX,mouseY,0x0)
              //forceMap.generateFilterRect(rect,filter);
            }
        }
        
        //noise reset
        private function resetFunc(e:Event = null):void{
            forceMap.perlinNoise(W,H,30, Math.floor( Math.random() * 0xFFFFFF ), false, true, 6, false, null);
        }
    }
}

import flash.display.*;

class Arrow extends Bitmap
{
    public var mx:Number = 0;
    public var my:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var ax:Number = 0;
    public var ay:Number = 0;

    public function Arrow( x:Number, y:Number,mx:Number,my:Number) {this.x = x;this.y = y;this.mx = mx;this.my = my;}
    public function update(aax:Number,aay:Number):void{
        ax += aax;
        ay += aay;
        vx += ax;
        vy += ay;
        x += vx;
        y += vy;
        ( x > mx ) ? x = 0 :( x < 0 ) ? x = mx : 0;
        ( y > my ) ? y = 0 :( y < 0 ) ? y = my : 0;
        ax *= .95;
        ay *= .95;
        vx *= .90;
        vy *= .90;
    }
}