/**
 * Copyright tktr90755 ( http://wonderfl.net/user/tktr90755 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yHdU
 */

// forked from umhr's code on 2008-12-23
/** 
*/
package
{
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.system.Security;
    import flash.text.TextField;
    
    
    public class FileLoader extends Sprite {

        public function FileLoader():void {
            stage.align=StageAlign.TOP_LEFT;
            stage.scaleMode=StageScaleMode.NO_SCALE;

            loader("http://wonderfl.net/static/tmp/related_images/7b0f000b19165103c1e4e3006287e5e9ddb8b325m");
            
        }
        
        private function loader(__url:String):void{
            
            var _loader:Loader = new Loader();
                _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
                _loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
                _loader.load(new URLRequest(__url));
        }
        
        private function completeHandler(event:Event):void {
            
            //写真を読み込み
            var loaderInfo:LoaderInfo=event.currentTarget as LoaderInfo;
            var loader:Loader = loaderInfo.loader;
            photoResize(loader);
            addChild(loader);
            
            //マスクを設定
            var _mask:Sprite = new Sprite();
            _mask.x = _mask.x - 10;
            _mask.y = _mask.y - 10;
            addChild(_mask);
            loader.mask = _mask; 
            var sliceMask:SliceMask = new SliceMask(_mask, 24, 25, 20, 20, 40, 10);
            
            //マスクアニメが終わるときのイベント
            _mask.addEventListener (SliceMask.MOTION_FINISHED, onComplete);
        }
        
        private function ioErrorHandler(event:IOErrorEvent):void {
        }
        
        private function photoResize(target:Loader):void {
            target.width = stage.stageWidth;
            target.height = stage.stageHeight;
            //符号が「>」ならば画面いっぱいに表示「<」ならば画面にフィットする
            if (target.scaleY > target.scaleX)
            {
                target.scaleX = target.scaleY;
            }
            else
            {
                target.scaleY = target.scaleX;
            }
            target.x = stage.stageWidth / 2 - target.width / 2;
            target.y = stage.stageHeight / 2 - target.height / 2;
        }
        
        //マスクアニメの終わりのタイミング
        private function onComplete (e:Event):void
        {
            var textField:TextField = new TextField(); 
            textField.textColor =0xFFFFFF;
            textField.text="終わったよ";    
            this.addChild(textField); 
        }
    }
    
}

import flash.display.DisplayObjectContainer;
import flash.display.MovieClip;
import flash.display.Shape;
import flash.events.Event;
import flash.text.TextField;
   
class SliceMask extends MovieClip
{
    //終わりのタイミング
    public static const MOTION_FINISHED:String = "motionFinished";
    //描画する場所
    private var container:DisplayObjectContainer;
    //縦に何個追加するか
    private var tate:uint;
    //横に何個追加するか
    private var yoko:uint;
    //配置の間隔X(Interval)
    private var intX:uint;
    //配置の間隔Y(Interval)
    private var intY:uint;
    //シェイプのでかさ
    private var shapeScale:uint;
    //スピード
    private var speed:uint;
    //終わりのタイミング
    private var endFlug1:uint;
    private var endFlug2:uint;
    public function SliceMask(_container:DisplayObjectContainer,_tate:uint, _yoko:uint, _intX:uint, _intY:uint, _shapeScale:uint,_speed:uint ) 
    {
        container = _container;
        tate = _tate;
        yoko = _yoko;
        intX = _intX;
        intY = _intY; 
        shapeScale = _shapeScale;
        speed = _speed;
        addShape();
    }
    private function addShape():void
    {
        //格子状にシェイプを配置
        for (var i:uint = 1; i < yoko; i++)
        {
            for (var j:uint = 1; j <= tate; j++)
            {
                //ナナメ左上から若い番号を振る
                var shape:Shape = new Shape();
                shape.graphics.beginFill(0xF00000);
                shape.graphics.drawRect( -(shapeScale/2), -(shapeScale/2), shapeScale, shapeScale);
                shape.graphics.endFill();
                shape.x = intX * i;
                shape.y = intY * j;
                shape.scaleX = 0;
                shape.scaleY = 0;
                shape.alpha = 0;
                shape.name = String(((i + j) - 1));
                container.addChild(shape);
                _move(shape);
                endFlug1 = (i * j);
            }
        }
    }
    private function _move (target:Shape):void
    {
        var timer:uint = 0;
        var rotate:Number = 180;
        var scale:Number = 1;
        var spd:Number = speed;
        var judge:Number = 0.1;
        target.addEventListener (Event.ENTER_FRAME,_onEnterFrame);
        function _onEnterFrame(e:Event):void
        {
            if (timer++ >= parseInt(target.name))
            {
                target.alpha = 1;
                target.rotation += (rotate - target.rotation) / spd;
                target.scaleX += (scale - target.scaleX) / spd;
                target.scaleY += (scale - target.scaleY) / spd;
                if (Math.abs (scale - target.scaleX) < judge && Math.abs (scale - target.scaleY) < judge && Math.abs (rotate - target.rotation) < judge)
                {
                    target.removeEventListener (Event.ENTER_FRAME, _onEnterFrame);
                    target.rotation = rotate;
                    target.scaleX = scale;
                    target.scaleY = scale;
                    endFlug2++;
                    end();
                }
            }
        };
    }
    //終わりのタイミング
    private function end():void
    {
        if (endFlug1 == endFlug2)
        {
            //モーションが終わったというイベントを送出
            container.dispatchEvent(new Event(MOTION_FINISHED));
        }
    }
}