/**
 * Copyright vasari ( http://wonderfl.net/user/vasari )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yGZU
 */

// forked from osamX's 重力マウス（画像貼っつけてみた）
// forked from fumix's forked from: 重力マウス（プチ軽量化：10万パーティクル）
// forked from clockmaker's 重力マウス（プチ軽量化：10万パーティクル）
// forked from coppieee's 重力マウス（さらに軽量化してみた）
// forked from paq's forked from: 重力マウス（ちょっぴり軽量化してみた）
// forked from fumix's 重力マウス（リンクリストにしてみた）
// forked from undo's 重力マウス
//　リンクリストにしてみたけどそんなに速くない？？
//_bmd.fillRect()を_bmd.setPixel()に変更。
//sin(),cos(),atan2(),sqrt()を排除。
// Add final class / mouseEnalbled = false by clockmaker
// 写真: http://sozai-free.com/sozai/00098.html
// クリックで重力！
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import net.hires.debug.Stats;

	[SWF(frameRate='60', width='465', height='465', backgroundColor='0x0')]

	import flash.utils.Dictionary;
	public class ParticleTest1 extends Sprite
	{
		private var _bmp:Bitmap;
		private var _bmd:BitmapData;
		private var _bmdRect:Rectangle;
		private var _colorTransform:ColorTransform = new ColorTransform(0.7, 0.7, 0.7, 1.0);

		private var _first:Node;
		//private var _maxNum:int = 100000; // 20万パーティクルでも45fpsぐらいでる
		private var _cnt:int = 0;
		
		private var _imgbmd:BitmapData;
		private const SIZE:int = 465;
		private var _maxNum:int = SIZE * SIZE;
		private var _mode:Boolean = true;

		public function ParticleTest1()
		{
			loadImg("http://flash-scope.com/wonderfl/GravMouse/kimonoimg.png");
		}
		
		private  function loadImg(url:String):void
		{
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void
			{
				_imgbmd = new BitmapData(465, 465);
				_imgbmd.draw(loader);
				addChild(new Bitmap(_imgbmd));
				init();
			});
			loader.load(new URLRequest(url), new LoaderContext(true));
		}

		private function init():void
		{	
			this.stage.align = StageAlign.TOP_LEFT;
			this.stage.scaleMode = StageScaleMode.NO_SCALE;
			this.stage.quality = "low";
			this.stage.frameRate = 30;
			this.mouseEnabled = false;
			this.mouseChildren = false;
		
			var old:Node;

			_bmd = new BitmapData(465, 465, false, 0x000000);
			_bmp = new Bitmap(_bmd);
			addChild(_bmp);
			this._bmdRect = _bmd.rect;

			for (var i:int = 0; i < this._maxNum; i++)
			{
				var n:Node = new Node();
				n.pos_y = n.start_y = (i / SIZE) >> 0;
				n.pos_x = n.start_x = i - SIZE * n.pos_y; 
				n.color = _imgbmd.getPixel(n.pos_x+1, n.pos_y+1);
				//リンクリスト
				if (_first == null) {
					old = _first = n;
				} else {
					old.next = n;
					old = n;
				}
			}
			
			stage.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void
			{
				_mode = !_mode;
			});
			
			addChild(new Stats());
			addEventListener(Event.ENTER_FRAME, onEnter);
		}

		private function onEnter(evt:Event):void
		{
			var gravPoint_x:Number = mouseX;
			var gravPoint_y:Number = mouseY;
			var n:Node = _first;
			var calc:Boolean = _cnt % 4 == 0;
			
			this._bmd.lock();
			do
			{
				if (!_mode) { //重力モード
					var diff_x:Number = gravPoint_x - n.pos_x;
					var diff_y:Number = gravPoint_y - n.pos_y;
					var acc:Number = 200 / (diff_x * diff_x + diff_y * diff_y);
					var acc_x:Number = acc * diff_x;
					var acc_y:Number = acc * diff_y;
					n.v_x += acc * diff_x;
					n.v_y += acc * diff_y;
					
					n.pos_x += n.v_x;
					n.pos_y += n.v_y;
				
					n.v_x *= 0.96;
					n.v_y *= 0.96;
					
				}
				else {	//帰還モード
					n.pos_x += (n.start_x - n.pos_x) / 2;
					n.pos_y += (n.start_y - n.pos_y) / 2;
				}
				
				this._bmd.setPixel(n.pos_x >> 0, n.pos_y >> 0, n.color); 
			}
			while (n = n.next);
			this._bmd.colorTransform(this._bmdRect, this._colorTransform);
			this._bmd.unlock();
			
			//_cnt ++;
		}
	}
}

final class Node
{
	public var v_x:Number = 0;
	public var v_y:Number = 0;
	public var pos_x:Number = 0;
	public var pos_y:Number = 0;
	public var next:Node;
	public var color:int;
	public var start_x:int = 0;
	public var start_y:int = 0;
}
