/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yG8X
 */

//
//	BlendMode.LIGHTENのテスト
//	LIGHTENは重なった部分の明るい方を取るので、円が重なると灰色の部分が排除される
//
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	
	[SWF(backgroundColor="0x00000000", frameRate="60")]

	/**
	 * ...
	 * @author okoi
	 */
	public class Main extends Sprite 
	{		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			for ( var i:int = 0; i < 10; i++ )
			{
				var circle:Circle = new Circle(stage.stageWidth/2,stage.stageHeight/2);
				addChild( circle );
			}
		}
		
	}
	
}
//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////
import flash.display.Sprite;
import flash.display.BlendMode;
import flash.events.Event;
//	チェック用円描画クラス
class Circle extends Sprite {
	
	private var moveX:Number = 0;
	private var moveY:Number = 0;
	
	public function Circle(_x:int, _y:int) {
		super();
		
		this.x = _x;
		this.y = _y;
		this.blendMode = BlendMode.LIGHTEN;
		
		graphics.beginFill( 0x555555 );
		graphics.drawCircle( 0, 0, 100 );
		graphics.endFill();
		
		graphics.beginFill( 0xFFFFFF, 1 );
		graphics.drawCircle( 0, 0, 80 );
		graphics.endFill();
		
		moveX = Math.random() * 5 - 2.5;
		moveY = Math.random() * 5 - 2.5;
		
		addEventListener(Event.ENTER_FRAME, EnterFrame);
	}
	
	//
	//	毎フレームテキトウに移動させる	
	//
	private function EnterFrame(event:Event):void {
		
		this.x += moveX;
		this.y += moveY;
		
		if ( this.x < 0 || this.x > stage.stageWidth ) moveX = -moveX;
		if ( this.y < 0 || this.y > stage.stageHeight ) moveY = -moveY;
	}
	
}