/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yG7R
 */

package {
    
    import flash.geom.*;
    import flash.display.*;
    
    public class FlashTest extends Sprite {
        
        private var anchor1:Point, anchor2:Point;
        private var control1:Point, control2:Point;
        private var divs:int;
        private var figSh:Shape;
        
        public function FlashTest() {
            
            anchor1 = new Point(100, 200);
            control1 = new Point(100, 100);
            control2 = new Point(300, 100);
            anchor2 = new Point(300, 200);
            
            divs = 50;
            figSh = new Shape();
            
            figSh.graphics.clear();
            figSh.graphics.beginFill ( 0xff8800 , 1.0 );
            figSh.graphics.drawCircle(anchor1.x, anchor1.y, 4);
            figSh.graphics.drawCircle(anchor2.x, anchor2.y, 4);
            
            figSh.graphics.beginFill ( 0x123456 , 1.0 );
            figSh.graphics.drawCircle(control1.x, control1.y, 4);
            figSh.graphics.drawCircle(control2.x, control2.y, 4);
            
            figSh.graphics.lineStyle(1, 0xFF1234);
            figSh.graphics.moveTo(anchor1.x, anchor1.y);
            figSh.graphics.lineTo(control1.x, control1.y);
            
            figSh.graphics.lineStyle(1, 0x012345);
            figSh.graphics.moveTo(anchor2.x, anchor2.y);
            figSh.graphics.lineTo(control2.x, control2.y);
            
            figSh.graphics.lineStyle(1, 0x012345);
            figSh.graphics.moveTo(anchor1.x, anchor1.y);
             
            var posx:Number;
            var posy:Number;
        
            for (var u:Number=0; u<=1; u+=1/divs) {
             
                posx = Math.pow(u, 3)*(anchor2.x + 3*(control1.x - control2.x) - anchor1.x)
                     + 3*Math.pow(u, 2)*(anchor1.x - 2*control1.x + control2.x)
                     + 3*u*(control1.x - anchor1.x) + anchor1.x;
                 
                posy = Math.pow(u, 3)*(anchor2.y + 3*(control1.y - control2.y) - anchor1.y)
                     + 3*Math.pow(u, 2)*(anchor1.y - 2*control1.y + control2.y)
                     + 3*u*(control1.y - anchor1.y) + anchor1.y;
                 
                figSh.graphics.drawCircle(posx, posy, 1);
             
            }
        
            figSh.graphics.lineTo(anchor2.x, anchor2.y);
            
            addChild(figSh);
            
        }
    }
}
