/**
 * Copyright noonat ( http://wonderfl.net/user/noonat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yE3C
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.utils.*;
    
    public class FlashTest extends Sprite {
        private const DEG_TO_RAD:Number = Math.PI / 180;
        
        private var _bitmaps:Vector.<Bitmap>;
        private var _buffer:BitmapData;
        private var _bufferIndex:int;
        private var _buffers:Vector.<BitmapData>;
        private var _elapsed:Number;
        private var _fps:int;
        private var _fpsText:TextField;
        private var _fpsTimer:Number;
        private var _matrix:Matrix;
        private var _sprite:BitmapData;
        private var _spriteBuffer:BitmapData;
        private var _text:TextField;
        private var _time:Number;
        private var _width:Number;
        private var _height:Number;
        private var _zero:Point;

        private var _points:Vector.<Point>;
        private var _velocities:Vector.<Point>;
        
        private var _bitmapFill:GraphicsBitmapFill;
        private var _bitmapFills:Vector.<GraphicsBitmapFill>;
        private var _data:Vector.<IGraphicsData>;
        private var _colorTransforms:Vector.<ColorTransform>;
        private var _endFill:GraphicsEndFill;
        private var _paths:Vector.<GraphicsPath>;
        private var _solidFills:Vector.<GraphicsSolidFill>;

        private var _sprites:Vector.<Bitmap>;
        private var _spritesContainer:Sprite;
        
        public function FlashTest() {
            addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
        }
        
        private function clear():void {
            _buffer.fillRect(_buffer.rect, 0);
        }
        
        private function flip():void {
            _bitmaps[_bufferIndex].visible = true;
            _bufferIndex = (_bufferIndex + 1) & 1;
            _buffer = _buffers[_bufferIndex];
            _bitmaps[_bufferIndex].visible = false;
        }
        
        private function log(...args):void {
            var s:String = '';
            for each (var arg:Object in args) {
                s += arg + ' ';
            }
            _text.appendText(s + '\n');
        }
        
        private function onAddedToStage(event:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
            stage.align = StageAlign.TOP_LEFT;
            stage.frameRate = 60;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _width = stage.stageWidth;
            _height = stage.stageHeight;
            
            _buffers = new Vector.<BitmapData>(2, true);
            _buffers[0] = new BitmapData(_width, _height, true, 0);
            _buffers[1] = new BitmapData(_width, _height, true, 0);
            _bitmaps = new Vector.<Bitmap>(2, true);
            _bitmaps[0] = new Bitmap(_buffers[0], PixelSnapping.AUTO, false);
            _bitmaps[0].visible = false;
            addChild(_bitmaps[0]);
            _bitmaps[1] = new Bitmap(_buffers[1], PixelSnapping.AUTO, false);
            _bitmaps[1].visible = false;
            addChild(_bitmaps[1]);
            
            _buffer = _buffers[0];
            _bufferIndex = 0;
            _matrix = new Matrix();
            
            _text = new TextField();
            _text.autoSize = TextFieldAutoSize.LEFT;
            _text.defaultTextFormat = new TextFormat('fixed');
            addChild(_text);
            
            _fps = 0;
            _fpsTimer = 0;
            _fpsText = new TextField();
            _fpsText.autoSize = TextFieldAutoSize.LEFT;
            _fpsText.defaultTextFormat = new TextFormat('fixed');
            addChild(_fpsText);

            _sprite = new BitmapData(32, 32, true, 0);
            _sprite.fillRect(new Rectangle( 0,  0, 16, 16), 0xffffffff);
            _sprite.fillRect(new Rectangle(16,  0, 16, 16), 0xffcccccc);
            _sprite.fillRect(new Rectangle( 0, 16, 16, 16), 0xff999999);
            _sprite.fillRect(new Rectangle(16, 16, 16, 16), 0xff000000);
            _spriteBuffer = new BitmapData(32, 32, true, 0);

            _zero = new Point(0, 0);
            _points = new Vector.<Point>(1024, true);
            _velocities = new Vector.<Point>(_points.length, true);
            for (var i:int = 0; i < _points.length; ++i) {
                _points[i] = new Point(
                    Math.random() * (_width - 32),
                    Math.random() * (_height - 32));
                _velocities[i] = new Point(
                    Math.random() < 0.5 ? -1 : 1,
                    Math.random() < 0.5 ? -1 : 1);
            }
            
            _bitmapFill = new GraphicsBitmapFill(_sprite, null, false, false);
            _bitmapFills = new Vector.<GraphicsBitmapFill>(_points.length, true);
            _colorTransforms = new Vector.<ColorTransform>(_points.length, true);
            _data = new Vector.<IGraphicsData>();
            _endFill = new GraphicsEndFill();
            _paths = new Vector.<GraphicsPath>(_points.length, true);
            _solidFills = new Vector.<GraphicsSolidFill>(_points.length, true);
            
            _sprites = new Vector.<Bitmap>(_points.length);
            _spritesContainer = new Sprite();
            _spritesContainer.visible = false;
            addChild(_spritesContainer);
            
            for (i = 0; i < _points.length; ++i) {
                var p:Point = _points[i];
                
                var tint:ColorTransform = new ColorTransform(
                    Math.random(), Math.random(), Math.random(), Math.random());
                var color:int = (
                    (int(255 * tint.redMultiplier) & 255) << 16 |
                    (int(255 * tint.greenMultiplier) & 255) << 8 |
                    (int(255 * tint.blueMultiplier) & 255));
                _colorTransforms[i] = tint;
                _solidFills[i] = new GraphicsSolidFill(color, tint.alphaMultiplier);
                    
                var matrix:Matrix = new Matrix();
                matrix.tx = p.x;
                matrix.ty = p.y;
                _bitmapFills[i] = new GraphicsBitmapFill(
                    _sprite, matrix, false, false);

                var path:GraphicsPath = new GraphicsPath();
                path.moveTo(p.x, p.y);
                path.lineTo(p.x + 32, p.y);
                path.lineTo(p.x + 32, p.y + 32);
                path.lineTo(p.x, p.y + 32);
                _paths[i] = path;

                var sprite:Bitmap = new Bitmap(_sprite, PixelSnapping.AUTO, false);
                sprite.x = p.x;
                sprite.y = p.y;
                sprite.transform.colorTransform = tint;
                _sprites[i] = sprite;
                _spritesContainer.addChild(sprite);
            }
            
            _time = getTimer() / 1000.0;
            _elapsed = 0;
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(event:Event):void {
            var time:Number = getTimer() / 1000.0;
            _elapsed = time - _time;
            _time = time;
            
            _fps += 1;
            _fpsTimer += _elapsed;
            if (_fpsTimer >= 1) {
                _fpsText.text = _fps.toString();
                _fpsTimer %= 1;
                _fps = 0;
            }
            
            var il:int = _points.length;
            for (var i:int = 0; i < il; ++i) {
                var point:Point = _points[i];
                var velocity:Point = _velocities[i];
                point.x += velocity.x * 5 * _elapsed;
                point.y += velocity.y * 5 * _elapsed;
                if (point.x < 0) {
                    point.x -= point.x % _width;
                    velocity.x *= -1;
                } else if (point.x > _width) {
                    point.x -= point.x % _width;
                    velocity.x *= -1;
                }
                if (point.y < 0) {
                    point.y -= point.y % _height;
                    velocity.y *= -1;
                } else if (point.y > _height) {
                    point.y -= point.y % _height;
                    velocity.y *= -1;
                }
                var sprite:Bitmap = _sprites[i];
                sprite.x = point.x;
                sprite.y = point.y;
                //sprite.rotation += 90 * _elapsed;
            }
            
            updateCopyPixels();
            //updateDrawGraphicsData();
            //updateDrawTriangles();
        }
        
        private function updateCopyPixels():void {
            clear();
            var il:int = _points.length;
            for (var i:int = 0; i < il; ++i) {
                var point:Point = _points[i];
                var sprite:Bitmap = _sprites[i];
                _spriteBuffer.fillRect(_spriteBuffer.rect, 0);
                _spriteBuffer.copyPixels(_sprite, _sprite.rect, _zero);
                _spriteBuffer.colorTransform(_spriteBuffer.rect, _colorTransforms[i]);
                if (sprite.rotation == 0) {
                    _buffer.copyPixels(_spriteBuffer, _spriteBuffer.rect, point, null, null, true);
                } else {
                    _matrix.identity();
                    _matrix.rotate(sprite.rotation * DEG_TO_RAD);
                    _matrix.tx += point.x;
                    _matrix.ty += point.y;
                    _buffer.draw(_spriteBuffer, _matrix, null, null, null, true);
                }
            }
            flip();
        }

        private function updateDrawGraphicsData():void {
            graphics.clear();
            var dl:int = _data.length = 0;
            var il:int = _paths.length;
            for (var i:int = 0; i < il; ++i) {
                var path:GraphicsPath = _paths[i];
                _data[dl++] = _bitmapFills[i];
                _data[dl++] = path;
                _data[dl++] = _solidFills[i];
                _data[dl++] = path;
            }
            graphics.drawGraphicsData(_data);
        }
    }
}
