/**
 * Copyright kura07 ( http://wonderfl.net/user/kura07 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yDdQ
 */

package {
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.GradientType;
    import flash.events.ContextMenuEvent;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.ui.ContextMenu;
    import flash.ui.ContextMenuItem;
    
    [SWF(width = 465, height = 465, frameRate = 60, backgroundColor = 0xffffff)]
    
    public class WindowCondensation extends Sprite {
        
        private const FINGER_WIDTH:uint = 30;
        private const BREATH_WIDTH:uint = 160;
        
        private var loader:Loader;
        
        private var cmenu:ContextMenu;
        private var cmitemTrace:ContextMenuItem;
        private var cmitemBreathe:ContextMenuItem;
        private var type:uint;
        
        private var sp:Sprite;
        private var bmp:Bitmap;
        private var bdata:BitmapData;
        
        private var spOrigin:Sprite;
        private var bdataOrigin:BitmapData;
        private var spOriginMask:Sprite;
        
        private var spFiltered:Sprite;
        private var bdataFiltered:BitmapData;
        private var spFilteredMask:Sprite;
        
        function WindowCondensation() {
            (sp = new Sprite()).addChild(bmp = new Bitmap(bdata = new BitmapData(465, 465)));
            (loader = new Loader()).contentLoaderInfo.addEventListener(Event.COMPLETE, onCompleteHandler);
            loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/9/94/9424/9424161f693535b9300045b7bd1b2cf4f41dfbbd"), new LoaderContext(true));
        }
        
        private function onCompleteHandler(e:Event):void {
            (spOrigin = new Sprite()).addChild(new Bitmap(bdataOrigin = new BitmapData(465, 465)));
            bdataOrigin.draw(loader);
            const m:Matrix = new Matrix();
            m.createGradientBox(FINGER_WIDTH, FINGER_WIDTH, 0, -FINGER_WIDTH / 2, -FINGER_WIDTH / 2);
            stage.addChild(spOrigin.mask = (new Sprite().addChild(spOriginMask = new Sprite()).parent)).visible = false;
            spOriginMask.graphics.beginGradientFill(GradientType.RADIAL, [0, 0], [1, 0], [150, 255], m);
            spOriginMask.graphics.drawCircle(0, 0, FINGER_WIDTH / 2);
            spOrigin.cacheAsBitmap = spOriginMask.parent.cacheAsBitmap = true;
            
            (spFiltered = new Sprite()).addChild(new Bitmap(bdataFiltered = new BitmapData(465, 465)));
            bdataFiltered.draw(loader);
            bdataFiltered.applyFilter(bdataFiltered, bdataFiltered.rect, new Point(), new BlurFilter(8, 8));
            bdataFiltered.applyFilter(bdataFiltered, bdataFiltered.rect, new Point(), new ColorMatrixFilter([
                .4, 0, 0, 0, 0xff * .6,
                0, .4, 0, 0, 0xff * .6,
                0, 0, .4, 0, 0xff * .6,
                0, 0, 0, 1, 0
            ]));
            m.createGradientBox(BREATH_WIDTH, BREATH_WIDTH, 0, -BREATH_WIDTH / 2, -BREATH_WIDTH / 2);
            stage.addChild(spFiltered.mask = (new Sprite().addChild(spFilteredMask = new Sprite()).parent)).visible = false;
            spFilteredMask.graphics.beginGradientFill(GradientType.RADIAL, [0, 0], [.2, 0], [100, 255], m);
            spFilteredMask.graphics.drawCircle(0, 0, BREATH_WIDTH / 2);
            spFiltered.cacheAsBitmap = spFilteredMask.parent.cacheAsBitmap = true;
            
            (cmenu = new ContextMenu()).hideBuiltInItems();
            (cmitemTrace = new ContextMenuItem("Trace with a finger")).addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, function(e:ContextMenuEvent):void { switchType(0); } );
            (cmitemBreathe = new ContextMenuItem("Breathe")).addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, function(e:ContextMenuEvent):void { switchType(1); } );
            (sp.contextMenu = cmenu).customItems = [cmitemTrace, cmitemBreathe];
            switchType(0);
            
            bdata.draw(bdataFiltered);
            stage.addChild(sp);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDownHandler);
        }
        
        private function switchType(_type:uint):void {
            type = _type;
            cmitemTrace.enabled = !!type;
            cmitemBreathe.enabled = !type;
        }
        
        private function onMouseDownHandler(e:MouseEvent):void {
            stage.removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDownHandler);
            if (!type) {
                stage.addEventListener(MouseEvent.MOUSE_MOVE, tracing);
                tracing();
            }
            else stage.addEventListener(Event.ENTER_FRAME, breathing);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUpHandler);
        }
        private function tracing(e:MouseEvent = null):void {
            spOriginMask.x = mouseX;
            spOriginMask.y = mouseY;
            bdata.draw(spOrigin);
        }
        private function breathing(e:Event):void {
            spFilteredMask.x = mouseX;
            spFilteredMask.y = mouseY;
            bdata.draw(spFiltered);
        }
        private function onMouseUpHandler(e:MouseEvent):void {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, tracing);
            stage.removeEventListener(Event.ENTER_FRAME, breathing);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUpHandler);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDownHandler);
        }
        
    }
    
}