/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yDaZ
 */

package {
    import flash.text.TextField;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            var hills:Hills = new Hills( stage );
            //var diagram:Diagramm = new Diagramm( stage );
            Biomes.convertToBiome( hills.heightMap, stage );
            //Biomes.convertToBiome( diagram.heightMap, stage );
            tf.autoSize = 'left';
            tf.x = 50; tf.y = 300;
            stage.addChild(tf);
        }
        private static var tf:TextField = new TextField();
        public static function trace(st:String='trace'):void{
            tf.text = st;
            //tf.appendText('\n'+st);
        }
    }
}
import flash.display.Shape;
import flash.geom.Point;

import flash.events.Event;
import flash.display.BlendMode;
import flash.geom.Matrix;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Stage;
import flash.display.Sprite;
import flash.display.GradientType; 

Class {
    class Biomes {                    // 0 = 59 Water
        public static const ALL_DRAW:String = 'allDraw';    // если меньше чем высота, тогда вернуть биом
        public static var biomesHeights:Array = [0xFF202020,0xFF404040,0xFF505050,0xFF595959,
                                                    0xFF616161,0xFF707070,0xFF808080, 0xFF909090,
                                                    0xFFA0A0A0,0xFFB0B0B0,0xFFC0C0C0,0xFFD0D0D0, 0xFFF0F0F0];
        public static var biomesColors:Array =  [0x020F32,0x04628C,0x02A9BD,0x649A8C,
                                                    0xDAB999,0xBD885F,0x8A5718, 0x3F2005,
                                                    0x305110,0x4E821A,0x759158,0xB3CFD3, 0xD9EFEF];
        private static var yNow:int = 0;       // это значит, что нужно... 
        private static var yMax:int = 0;
        private static var myMap:BitmapData;
        private static var stg:Stage;
        public static function convertToBiome(heightMap:BitmapData, stg:Stage):void{
            Biomes.yMax = heightMap.height;
            Biomes.myMap = heightMap;
            Biomes.stg = stg;
            stg.addEventListener(Event.ENTER_FRAME, drawRow);
        }
        private static function drawRow(e:Event):void{
            if(yNow < yMax){
                var oldColor:uint;
                var newColor:uint;
                for(var x:int=0; x<myMap.width; x++){
                    oldColor = myMap.getPixel32( x, yNow );
                    newColor = getNewColor( oldColor );
                    //FlashTest.trace( newColor.toString() );
                    myMap.setPixel32( x, yNow, newColor );
                }
                yNow++;
            } else {
                stg.removeEventListener(Event.ENTER_FRAME, drawRow);
                stg.dispatchEvent(new Event(ALL_DRAW));
            }
        }
        private static function getNewColor(height:uint):uint{
            for(var i:int = 0; i < biomesHeights.length; i++){
                //FlashTest.trace( height.toString()+ ' ^ ' + String(biomesHeights[i]) );//String(height < biomesHeights[i]) );
                if(height <= biomesHeights[i]){
                    return biomesColors[i];
                }
            }
            return 0xFFFFFF;
        }
    }
}
Class {
    class Diagramm extends Sprite {
        public var heightMap:BitmapData;
        private var display:Bitmap;
        private var stg:Stage;
        private var points:Array = [];
        public function Diagramm(stg:Stage):void {
            this.stg = stg;
            stg.addChild(this);
            heightMap = new BitmapData(stg.stageWidth, stg.stageHeight, false, 0x606060);
            display = new Bitmap(heightMap,'auto',true);
            addChild(display);
            createPoints();
        }
        private function createPoints():void {
            var m:Matrix = new Matrix();
            var t:Shape = new Shape();
            t.graphics.beginFill(0xff0000);
            t.graphics.drawCircle(0,0,2);
            for(var i:int=0; i<256; i++){
                var nP:Point = new Point(stg.stageWidth*Math.random(),stg.stageHeight*Math.random());
                points.push( nP );
                m.tx = nP.x; m.ty = nP.y;
                heightMap.draw(t,m);
            }
        }
    }
}

Class {
    class Hills extends Sprite {    // I think that I need also simple noize add...
        public var heightMap:BitmapData;
        private var display:Bitmap;
        private var stg:Stage;
        public function Hills(stg:Stage):void {
            this.stg = stg;
            stg.addChild(this);
            // 0x888888 - sea height
            heightMap = new BitmapData(stg.stageWidth, stg.stageHeight, false, 0x606060);
            display = new Bitmap(heightMap); //,'auto',true);
            //display.filters = [];
            addChild(display);
            //createStartNoise();
            addHills(256);
        }
        private function createStartNoise():void{
            heightMap.noise(42,0,255,7,true);
        }
        private var hill:Sprite = new Sprite();
        private var m:Matrix = new Matrix();
        private function addHill(x:int,y:int):void {    // simple radial gradient...
            var byPoint:uint = heightMap.getPixel32(x,y);
            var centerColor:uint = byPoint - 0x585858;
            hill.graphics.clear();
            hill.graphics.beginGradientFill(GradientType.RADIAL, [centerColor, byPoint], [1,0], [0,255]  );
            hill.graphics.drawCircle(0,0,100);
            m.tx = x;
            m.ty = y;
            var mode:String = BlendMode.ADD;
            var rand:Number = Math.random();
            if(rand>.6)
                mode = BlendMode.INVERT;
            if(rand<.3)
                mode = BlendMode.DIFFERENCE;
            heightMap.draw(hill,m,null,mode);
        }
        private function addHills(num:int = 42):void {    // 
            // у меня есть функция рандома, точка Х и точка У
            // мне нужно подчинить рандом - формуле
            for(var i:int = 0; i<num; i++){
                addHill(stg.stageWidth*Math.random(), stg.stageHeight*Math.random());
            } // сейчас - полный рандом
        }
    }
}
