/**
 * Copyright staticmh ( http://wonderfl.net/user/staticmh )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yD3z
 */

// forked from yuuganisakase's TextAnim
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flupie.textanim.*;
    import net.wonderfl.utils.FontLoader;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Sine;
    import org.libspark.betweenas3.tweens.ITween;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xffeedd)]
    public class TextAnimation extends Sprite 
    {
        private var anim:TextAnim;
        private var tf:TextField;

        public function TextAnimation():void 
        {
Wonderfl.capture_delay(10);
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            var f:FontLoader = new FontLoader();
            f.load("Aqua");
            f.addEventListener(Event.COMPLETE, onLoad);
        }

        private function onLoad(e:Event):void 
        {
            tf = new TextField();
            const Wid:int = 310;
            var format:TextFormat = new TextFormat("_sans", 16, 0x777733);
            format.indent = 20;
            tf.defaultTextFormat = format;
            tf.width = Wid;
            tf.wordWrap = true;
            tf.embedFonts = true;
            tf.text = "א וַיְהִי בִּימֵי אֲחַשְׁוֵרוֹשׁ הוּא אֲחַשְׁוֵרוֹשׁ הַמֹּלֵךְ מֵהֹדּוּ וְעַד כּוּשׁ שֶׁבַע וְעֶשְׂרִים וּמֵאָה מְדִינָה. ב בַּיָּמִים הָהֵם כְּשֶׁבֶת הַמֶּלֶךְ אֲחַשְׁוֵרוֹשׁ עַל כִּסֵּא מַלְכוּתוֹ אֲשֶׁר בְּשׁוּשַׁן הַבִּירָה. ג בִּשְׁנַת שָׁלוֹשׁ לְמָלְכוֹ עָשָׂה מִשְׁתֶּה לְכָל שָׂרָיו וַעֲבָדָיו חֵיל פָּרַס וּמָדַי הַפַּרְתְּמִים וְשָׂרֵי הַמְּדִינוֹת לְפָנָיו. ד בְּהַרְאֹתוֹ אֶת עֹשֶׁר כְּבוֹד מַלְכוּתוֹ וְאֶת יְקָר תִּפְאֶרֶת גְּדוּלָּתוֹ יָמִים רַבִּים שְׁמוֹנִים וּמְאַת יוֹם. ה וּבִמְלוֹאת הַיָּמִים הָאֵלֶּה עָשָׂה הַמֶּלֶךְ לְכָל הָעָם הַנִּמְצְאִים בְּשׁוּשַׁן הַבִּירָה לְמִגָּדוֹל וְעַד קָטָן מִשְׁתֶּה שִׁבְעַת יָמִים בַּחֲצַר גִּנַּת בִּיתַן הַמֶּלֶךְ. ו חוּר כַּרְפַּס וּתְכֵלֶת אָחוּז בְּחַבְלֵי בוּץ וְאַרְגָּמָן עַל גְּלִילֵי כֶסֶף וְעַמּוּדֵי שֵׁשׁ מִטּוֹת זָהָב וָכֶסֶף עַל רִצְפַת בַּהַט וָשֵׁשׁ וְדַר וְסֹחָרֶת. ז וְהַשְׁקוֹת בִּכְלֵי זָהָב וְכֵלִים מִכֵּלִים שׁוֹנִים וְיֵין מַלְכוּת רָב כְּיַד הַמֶּלֶךְ. ח וְהַשְּׁתִיָּה כַדָּת אֵין אֹנֵס כִּי כֵן יִסַּד הַמֶּלֶךְ עַל כָּל רַב בֵּיתוֹ לַעֲשׂוֹת כִּרְצוֹן אִישׁ וָאִישׁ. ט גַּם וַשְׁתִּי הַמַּלְכָּה עָשְׂתָה מִשְׁתֵּה נָשִׁים בֵּית הַמַּלְכוּת אֲשֶׁר לַמֶּלֶךְ אֲחַשְׁוֵרוֹשׁ.    י בַּיּוֹם הַשְּׁבִיעִי כְּטוֹב לֵב הַמֶּלֶךְ בַּיָּיִן אָמַר לִמְהוּמָן בִּזְּתָא חַרְבוֹנָא בִּגְתָא וַאֲבַגְתָא זֵתַר וְכַרְכַּס שִׁבְעַת הַסָּרִיסִים הַמְשָׁרְתִים אֶת פְּנֵי הַמֶּלֶךְ אֲחַשְׁוֵרוֹשׁ. יא לְהָבִיא אֶת וַשְׁתִּי הַמַּלְכָּה לִפְנֵי הַמֶּלֶךְ בְּכֶתֶר מַלְכוּת לְהַרְאוֹת הָעַמִּים וְהַשָּׂרִים אֶת יָפְיָהּ כִּי טוֹבַת מַרְאֶה הִיא. יב וַתְּמָאֵן הַמַּלְכָּה וַשְׁתִּי לָבוֹא בִּדְבַר הַמֶּלֶךְ אֲשֶׁר בְּיַד הַסָּרִיסִים וַיִּקְצֹף הַמֶּלֶךְ מְאֹד וַחֲמָתוֹ בָּעֲרָה בוֹ. יג וַיֹּאמֶר הַמֶּלֶךְ לַחֲכָמִים יֹדְעֵי הָעִתִּים כִּי כֵן דְּבַר הַמֶּלֶךְ לִפְנֵי כָּל יֹדְעֵי דָּת וָדִין. יד וְהַקָּרֹב אֵלָיו כַּרְשְׁנָא שֵׁתָר אַדְמָתָא תַרְשִׁישׁ מֶרֶס מַרְסְנָא מְמוּכָן שִׁבְעַת שָׂרֵי פָּרַס וּמָדַי רֹאֵי פְּנֵי הַמֶּלֶךְ הַיֹּשְׁבִים רִאשֹׁנָה בַּמַּלְכוּת. טו כְּדָת מַה לַּעֲשׂוֹת בַּמַּלְכָּה וַשְׁתִּי עַל אֲשֶׁר לֹא עָשְׂתָה אֶת מַאֲמַר הַמֶּלֶךְ אֲחַשְׁוֵרוֹשׁ בְּיַד הַסָּרִיסִים.    טז וַיֹּאמֶר מומכן [מְמוּכָן] לִפְנֵי הַמֶּלֶךְ וְהַשָּׂרִים לֹא עַל הַמֶּלֶךְ לְבַדּוֹ עָוְתָה וַשְׁתִּי הַמַּלְכָּה כִּי עַל כָּל הַשָּׂרִים וְעַל כָּל הָעַמִּים אֲשֶׁר בְּכָל מְדִינוֹת הַמֶּלֶךְ אֲחַשְׁוֵרוֹשׁ. יז כִּי יֵצֵא דְבַר הַמַּלְכָּה עַל כָּל הַנָּשִׁים לְהַבְזוֹת בַּעְלֵיהֶן בְּעֵינֵיהֶן בְּאָמְרָם הַמֶּלֶךְ אֲחַשְׁוֵרוֹשׁ אָמַר לְהָבִיא אֶת וַשְׁתִּי הַמַּלְכָּה לְפָנָיו וְלֹא בָאָה. יח וְהַיּוֹם הַזֶּה תֹּאמַרְנָה שָׂרוֹת פָּרַס וּמָדַי אֲשֶׁר שָׁמְעוּ אֶת דְּבַר הַמַּלְכָּה לְכֹל שָׂרֵי הַמֶּלֶךְ וּכְדַי בִּזָּיוֹן וָקָצֶף. יט אִם עַל הַמֶּלֶךְ טוֹב יֵצֵא דְבַר מַלְכוּת מִלְּפָנָיו וְיִכָּתֵב בְּדָתֵי פָרַס וּמָדַי וְלֹא יַעֲבוֹר אֲשֶׁר לֹא תָבוֹא וַשְׁתִּי לִפְנֵי הַמֶּלֶךְ אֲחַשְׁוֵרוֹשׁ וּמַלְכוּתָהּ יִתֵּן הַמֶּלֶךְ לִרְעוּתָהּ הַטּוֹבָה מִמֶּנָּה. כ וְנִשְׁמַע פִּתְגָם הַמֶּלֶךְ אֲשֶׁר יַעֲשֶׂה בְּכָל מַלְכוּתוֹ כִּי רַבָּה הִיא וְכָל הַנָּשִׁים יִתְּנוּ יְקָר לְבַעְלֵיהֶן לְמִגָּדוֹל וְעַד קָטָן. כא וַיִּיטַב הַדָּבָר בְּעֵינֵי הַמֶּלֶךְ וְהַשָּׂרִים וַיַּעַשׂ הַמֶּלֶךְ כִּדְבַר מְמוּכָן. כב וַיִּשְׁלַח סְפָרִים אֶל כָּל מְדִינוֹת הַמֶּלֶךְ אֶל מְדִינָה וּמְדִינָה כִּכְתָבָהּ וְאֶל עַם וָעָם כִּלְשׁוֹנוֹ לִהְיוֹת כָּל אִישׁ שֹׂרֵר בְּבֵיתוֹ וּמְדַבֵּר כִּלְשׁוֹן עַמּוֹ.";

            tf.x = (465-Wid)/2;
            tf.y = 50;
            addChild(tf);
            tf.autoSize = TextFieldAutoSize.LEFT;
            stage.addEventListener(MouseEvent.CLICK, onClick);
            createTextAnim(1100);
        }
        private function createTextAnim(delay:int = 0):void
        {
            if (anim != null) {
                anim.dispose();
                addChild(tf);
            }
            anim = new TextAnim(tf);
            anim.mode = TextAnimMode.FIRST_LAST;
            anim.blocksVisible = false;
            anim.effects = myEffect;
            anim.interval = 20;
            anim.start(delay);
        }
        private function myEffect(block:TextAnimBlock):void
        {
            var bez:ITween = BetweenAS3.bezier(block, { }, { x:mouseX-tf.x ,y:mouseY-tf.y}, { x:-200, y:block.y-90}, 1.3, Sine.easeOut);
            bez.play();
        }
        private function onClick(e:MouseEvent):void 
        {
            createTextAnim(20);
        }        
    }    
}