/**
 * Copyright alexchirila87 ( http://wonderfl.net/user/alexchirila87 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yD3a
 */

// forked from coppieee's 重力マウス（さらに軽量化してみた）
// forked from paq's forked from: 重力マウス（ちょっぴり軽量化してみた）
// forked from fumix's 重力マウス（リンクリストにしてみた）
// forked from undo's 重力マウス
//　リンクリストにしてみたけどそんなに速くない？？
//_bmd.fillRect()を_bmd.setPixel()に変更。
//sin(),cos(),atan2(),sqrt()を排除。
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import net.hires.debug.Stats;

    [SWF(frameRate='30', backgroundColor='0x0')]

    public class ParticleTest1 extends Sprite
    {
        private var _bmp:Bitmap;
        private var _bmd:BitmapData;
        private var _bmdRect:Rectangle;
        //private var _colorTransform:ColorTransform = new ColorTransform(0.0, .2, 0.83, 1.0);

        private var _nodeArray:Array = [];
        private var _first:Node;
        private const _maxNum:int = 60000;
        private const _width:int = 465;
        private const _height:int = 465;
        
        private const _colorBack:uint  = 0x000000;
        private const _colorAlpha:uint = 0xcf0000;
        private const _colorBeta:uint = 0x0000df;
        
        private var isButtonDown:Boolean = false;
        
        public function ParticleTest1()
        {
            this.stage.align = StageAlign.TOP_LEFT;
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(evt:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            var old:Node;

            _bmd = new BitmapData(_width, _height, false, _colorBack);
            _bmp = new Bitmap(_bmd);
            addChild(_bmp);
            this._bmdRect = new Rectangle(0, 0, _width, _height);

            for (var i:int = 0; i < this._maxNum; i++)
            {
                var n:Node = new Node();
                n.pos_x = Math.random() * _width;
                n.pos_y = Math.random() * _height;
                n.mass = 0.5 + Math.floor((Math.random() + 0.5));
                //n.mass = 1;
                
                this._nodeArray.push(n);
                //リンクリスト
                if (_first == null) {
                    old = _first = n;
                } else {
                    old.next = n;
                    old = n;
                }
            }
            
            //addChild(new Stats());
            addEventListener(Event.ENTER_FRAME, onEnter);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, MouseListener);
            stage.addEventListener(MouseEvent.MOUSE_UP, MouseListener);
        }
        
        private function MouseListener(evt:MouseEvent):void
        {
            if (evt.type == MouseEvent.MOUSE_DOWN)
                this.isButtonDown = true;
            else if (evt.type == MouseEvent.MOUSE_UP)
                this.isButtonDown = false;
        }
        
        private function onEnter(evt:Event):void
        {
            var gravPoint_x:Number = mouseX;
            var gravPoint_y:Number = mouseY;
            var gravPoint_k:Number = 50;
            
            var gravPointTop_x:Number = mouseX;
            var gravPointTop_y:Number = mouseY - _height;
            var gravPointTop_k:Number = 50;
            
            var gravPointBottom_x:Number = mouseX;
            var gravPointBottom_y:Number = mouseY + _height;
            var gravPointBottom_k:Number = 50;
            
            var gravPointLeft_x:Number = mouseX - _width;
            var gravPointLeft_y:Number = mouseY;
            var gravPointLeft_k:Number = 50;

            var gravPointRight_x:Number = mouseX + _width;
            var gravPointRight_y:Number = mouseY;
            var gravPointRight_k:Number = 50;
            
            var n:Node = _first;
            this._bmd.lock();
            this._bmd.fillRect(new Rectangle(0, 0, _width, _height), _colorBack);
            do
            {
                if (this.isButtonDown) {
                    var diff_x:Number = gravPoint_x - n.pos_x;
                    var diff_y:Number = gravPoint_y - n.pos_y;
                    
                    var diffTop_x:Number = gravPointTop_x - n.pos_x;
                    var diffTop_y:Number = gravPointTop_y - n.pos_y;
                    
                    var diffBottom_x:Number = gravPointBottom_x - n.pos_x;
                    var diffBottom_y:Number = gravPointBottom_y - n.pos_y;
                
                    var diffLeft_x:Number = gravPointLeft_x - n.pos_x;
                    var diffLeft_y:Number = gravPointLeft_y - n.pos_y;
                
                    var diffRight_x:Number = gravPointRight_x - n.pos_x;
                    var diffRight_y:Number = gravPointRight_y - n.pos_y;
                
                    var acc:Number = gravPoint_k/(diff_x * diff_x + diff_y * diff_y);
                    var accTop:Number = gravPointTop_k/(diffTop_x * diffTop_x + diffTop_y * diffTop_y);
                    var accBottom:Number = gravPointBottom_k/(diffBottom_x * diffBottom_x + diffBottom_y * diffBottom_y);
                    var accLeft:Number = gravPointLeft_k/(diffLeft_x * diffLeft_x + diffLeft_y * diffLeft_y);
                    var accRight:Number = gravPointBottom_k/(diffRight_x * diffRight_x + diffRight_y * diffRight_y);
                    
                    var acc_x:Number = n.mass * (acc*diff_x + accTop*diffTop_x + accBottom*diffBottom_x + accLeft*diffLeft_x + accRight*diffRight_x);
                    var acc_y:Number = n.mass * (acc*diff_y + accTop*diffTop_y + accBottom*diffBottom_y + accLeft*diffLeft_y + accRight*diffRight_y);
                
                    n.v_x += acc_x;
                    n.v_y += acc_y;
                }
                
                n.pos_x += n.v_x;
                n.pos_y += n.v_y;
                
                n.v_x *= 0.96;
                n.v_y *= 0.96;

                
                if (n.pos_x > _width)
                    n.pos_x -= _width;
                else if (n.pos_x < 0)
                    n.pos_x += _width;
                    
                if (n.pos_y > _height)
                    n.pos_y -= _height;
                else if (n.pos_y < 0)
                    n.pos_y += _height;
                
                //var pxl:Number = this._bmd.getPixel(n.pos_x,n.pos_y); TODO: additive blend
                
                this._bmd.setPixel(n.pos_x,n.pos_y, (n.mass > 1) ? _colorAlpha : _colorBeta);
              //  this._bmd.setPixel(n.pos_x,n.pos_y, 0xffffff);
            }
            while (n = n.next);
            //this._bmd.colorTransform(this._bmdRect, this._colorTransform);
            this._bmd.unlock();
        }
    }
}

import flash.geom.Point;

class Node
{
//    public var acc_x:Number;
//    public var acc_y:Number;
    public var v_x:Number = 0;
    public var v_y:Number = 0;
    public var pos_x:Number = 0;
    public var pos_y:Number = 0;
    public var mass:Number = 1;
    public var next:Node;
}
