/**
 * Copyright hacker_yk666qry ( http://wonderfl.net/user/hacker_yk666qry )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yChN
 */

// forked from hacker_yk666qry's PagerSample
package {
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
    import flash.display.Sprite;
    public class PagerSample extends Sprite {
    	
    		private var _pager:Pager;
    		private var _numField:TextField;
    		
    		//コンストラクタ
        public function PagerSample() {
        		
        		_pager = new Pager(60);
        		
        		_numField = new TextField();
        		_numField.width = 60;
        		_numField.height = 24;
        		_numField.autoSize = TextFieldAutoSize.LEFT;
        		_numField.border = true;
        		addChild(_numField);
        		
        		var btnPrev:Sprite = new PageButton("PREV");
        		var btnNext:Sprite = new PageButton("NEXT");
        		
        		btnPrev.x = 70;
        		btnNext.x = 110;
        		
        		addChild(btnPrev);
        		addChild(btnNext);
        		
        		btnPrev.addEventListener( MouseEvent.CLICK, prevPage);
        		btnNext.addEventListener( MouseEvent.CLICK, nextPage );
        		
        		updatePager();
        }
        
        //max, minの説明
        //http://www.openspc2.org/reibun/FlashMX2004/ActionScript/Math/009/index.html
        private function prevPage(e:MouseEvent):void { 
        		_pager.prev();
        		
        		updatePager();
        }
        
        private function nextPage(e:MouseEvent):void {
        		_pager.next();
        		
        		updatePager();
        }
        
        private function updatePager():void {
        		_numField.text = String(_pager.currentPage + 1 ) + "/" + _pager.totalPages + " Page";
        }
    }
}


import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;

class PageButton extends Sprite {
	
	//コンストラクタ
	public function PageButton(label:String) {
		var textField:TextField = new TextField();
		textField.autoSize = TextFieldAutoSize.LEFT;
		textField.border = true;
		textField.text = label;
		addChild(textField);
		buttonMode = true;
		mouseChildren = false;
	}
}


class Pager {
	private var _currentPage:int;
	private var _totalPages:int;
	private var _numField:TextField;
	
	//コンストラクタ
	public function Pager(totalPages:int) {
		_currentPage = 0;
		_totalPages = totalPages;
	}
	
	//max(num1, num2):num1とnum2の数字を比較して大きい値をかえす
	public function prev():void {
		_currentPage = Math.max ( 0, _currentPage - 1);
	}
	
	//min(num1, num2):num1とnum2の数字を比較して小さい値をかえす
	public function next():void {
		_currentPage = Math.min ( _totalPages - 1, _currentPage + 1 );
	}

	public function get　currentPage():int {
		return _currentPage;
	}
	
	public function get totalPages():int {
		return _totalPages;
	}
}

