/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yCLu
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.*;
    import flash.filters.BlurFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundTransform;
    
    [SWF(width = "465", height = "465", backgroundColor = "0xFFFFFF", frameRate = "60")]
    
    public class Main extends Sprite
    {
        
        private const W:int = 465;
        private const H:int = 465;
        private const DISTORTION:int = 32;
        
        private var _loader:Loader;
        
        private var _particles:Array = [];
        private var _startX:Number;
        private var _startY:Number;
        
        private var _canvas:BitmapData;
        private var _mapBmd:BitmapData;
        private var _ct:ColorTransform;
        
        private var _perlinoffset:Array = [new Point()];
        private var _randomSeed:int = Math.random() * 0xFF;
        private var _isClicked:Boolean;
        private var _distScale:int;
        
        private var _bubble:Bitmap;
        private var _base:BitmapData; 
        private var _isEmitte:Boolean;
        
        private var _sound:Sound;
        private var _sc:SoundChannel = new SoundChannel();
        private var _vol:Number = 1;
        
        public function Main()
        {
            Security.loadPolicyFile("http://www.digifie.jp/crossdomain.xml");
            loadImage("http://www.digifie.jp/assets/images/bubble.png");
            _sound = new Sound(new URLRequest("http://www.digifie.jp/assets/sound/tempra.mp3"));
        }
        
        private function loadImage(url:String):void {
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoaded);
            _loader.load(new URLRequest(url));
        }
        
        private function onLoaded(e:Event):void {
            _loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onLoaded);
            setup();
        }
        
        private function setup():void
        {
            _base = new BitmapData(W * .5, H * .5);
            _base.perlinNoise(W, H, 4, Math.random() * 0xFF, true, true, 1, true);
            _base.colorTransform(_base.rect, new ColorTransform(1.25, 1.12, .6));
            
            _canvas = new BitmapData(W * .5, H * .5, false, 0xB69033);
            var canvas:Bitmap = new Bitmap(_canvas, "auto", true);
            canvas.scaleX = canvas.scaleY = 2.2;
            canvas.x = canvas.y = -20;
            addChild(canvas);
            //
            _mapBmd = new BitmapData(W * .5, H * .5, false, 0);
            _distScale = DISTORTION;
            //
            _bubble = _loader.content as Bitmap;
            _bubble.smoothing = true;
            //
            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
            
        }
        
        private function createParticle():void
        {
            var p:Particle = new Particle();
            var radius:Number = Math.random() * Math.sqrt(Math.random()) * 3.5;
            var angle:Number = Math.random() * (Math.PI) * 2;
            _startX += (mouseX - _startX) * .01 + Math.random() * 10 - 5;
            _startY += (mouseY - _startY) * .01 + Math.random() * 10 - 5;
            p.x = _startX * .48;
            p.y = _startY * .48;
            p.vx = Math.cos(angle) * radius;
            p.vy = Math.sin(angle) * radius;
            p.scale = Math.random() * .1;
            _particles.push(p);
        }
        
        private function emitte():void
        {
            var n:int = Math.random() * 20 + 20;
            _startX = mouseX;
            _startY = mouseY;
            while (n--) createParticle();
        }
        
        private function update(e:Event):void
        {
            _canvas.lock();
            _canvas.copyPixels(_base, _base.rect, new Point());
            _canvas.applyFilter(_canvas, _canvas.rect, new Point(), new BlurFilter(2, 2));
            //
            _mapBmd.perlinNoise(int(W / 15), int(H / 15), 1, _randomSeed, false, true, 1, true, _perlinoffset);
            var dmf:DisplacementMapFilter = new DisplacementMapFilter(_mapBmd,
                                                                    new Point(0,0),
                                                                    1,
                                                                    1,
                                                                    _distScale,
                                                                    _distScale);
            if(_isEmitte) {
                _perlinoffset[0].x -=  Math.random() * 20;
                _perlinoffset[0].y -=  Math.random() * 20;
            }else{
                _perlinoffset[0].x -=  1;
                _perlinoffset[0].y -=  1;
            }
            _canvas.applyFilter(_base, _base.rect, new Point(), dmf);
            //
            var n:int = _particles.length;
            while (n--) {
                var v:Number = Math.random() * 0.15 + 0.85;
                var p:Particle = _particles[n];
                var ranx:Number = Math.random() * .2 - .1;
                var rany:Number = Math.random() * .2 - .1;
                p.vx += ranx;
                p.vy += rany;
                p.vx *= v;
                p.vy *= v;
                p.x += p.vx;
                p.y += p.vy;
                //
                var bmd:BitmapData = new BitmapData(_bubble.width * 1.2, _bubble.height * 1.2, true, 0);
                var mrx:Matrix = new Matrix(p.scale, 0, 0, p.scale);
                var num:Number = 1 - p.scale;
                var ctf:ColorTransform = new ColorTransform(1, .95, .8, num - .2); 
                bmd.draw(_bubble, mrx, ctf, null, null, false);
                _canvas.copyPixels(bmd, bmd.rect, new Point(p.x, p.y));
                bmd.dispose();
                //
                if(p.scale <= .6) p.scale += .01
                if ((p.x > stage.stageWidth || 
                    p.x < 0) || 
                    (p.y < 0 || p.y > stage.stageHeight) || 
                    Math.abs(p.vx) < .05 || 
                    Math.abs(p.vy) < .05){
                    _particles.splice(n, 1);
                }
            }
            _canvas.unlock();
            if(_isEmitte) emitte();
        }
        
        private function onDown(e:MouseEvent):void{
            _isEmitte = true;
            _sc = _sound.play(0, 999);
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
        }
        private function onUp(e:MouseEvent):void{
            _isEmitte = false;
            stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
            //
            addEventListener(Event.ENTER_FRAME, fadeOut);
        }
        
        private function fadeOut(e:Event):void{
            if(_vol >= 0){
                var trans:SoundTransform = new SoundTransform(_vol, 0);
                _sc.soundTransform = trans;
                _vol -= .03;
            }else{
                removeEventListener(Event.ENTER_FRAME, fadeOut);
                _sc.stop();
                _vol = 1;
            }
        }
    }
}


import flash.geom.Point;

internal class Particle extends Point
{
    public var vx:Number = 0
    public var vy:Number = 0
    public var scale:Number = 0;
    public var c:uint = 0xFFFFFF;
}