/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yBvH
 */

/*
 *
 *
 *
*/

package {
    import flash.display.Sprite;
    
    [SWF(backgroundColor=0x000000)]
    public class MovePlate extends Sprite {
        public function MovePlate() {
            init();            
        }
        
        private function init():void {
            var plate:Plate = new Plate();
            plate.x = stage.stageWidth / 2 - plate.width / 2 - 5;
            plate.y = stage.stageHeight / 2;
            addChild( plate );
            
            var plate2:Plate = new Plate();
            plate2.x = stage.stageWidth / 2 + plate.width / 2 + 5;
            plate2.y = stage.stageHeight / 2;
            addChild( plate2 );
        }

    }
}

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    class Plate extends Sprite
    {
        private var basePoint:Point;
        private var shape:Sprite;
        private var pin:Sprite;
        private var w:Number;
        private var h:Number;
        private var color:uint;
        private var al:Number;
        private var drag:Boolean;
        private var curMouse:Point;
        private var preMouse:Point;
        private var va:Number = 0;
        private var targetAngle:Number = 0;
        private var spring:Number = 0.04;
        private var friction:Number = 0.9;
        
        public function Plate(_w:Number=100, _h:Number=200, _color:uint=0xffffff, _al:Number=0.7 ) 
        {
            w = _w;
            h = _h;
            color = _color;
            al = _al;
            curMouse = this.localToGlobal( new Point( mouseX, mouseY ) );
            
            init();
        }
        
        private function init():void {
            //基点を作成
            basePoint = new Point(0, 0);
            
            //回転させる図形を描画
            shape = new Sprite();
            shape.graphics.beginFill( color, al );
            shape.graphics.drawRect( -w / 2, -h / 2, w, h );
            shape.graphics.endFill();
            addChild( shape );
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        }
        
        private function onEnterFrame(e:Event):void {
            preMouse = curMouse;
            curMouse = this.localToGlobal( new Point( mouseX, mouseY ) );
            
            if( drag ){
                var vMouse:Number = curMouse.x - preMouse.x;
                va += vMouse * 0.1;
            }
            
            //rotationの取得
            var r:Number;
            var r1:Number = this.rotation;
            var r2:Number = this.rotation + 360;

            if ( Math.abs( targetAngle - r2 ) > Math.abs( targetAngle - r1 ) ) {
                r = r1 ;
            } else {
                r = r2;
            }
            
            var da:Number = targetAngle - r;
            var aa:Number = da * spring;
            va += aa;
            va *= friction;
            this.rotation += va;
        }
        
        private function onMouseDown(e:MouseEvent):void {
            parent.setChildIndex( this, parent.numChildren - 1 );
            
            startDrag();
            drag = true;
            addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            
            chageBasePoint();
        }
        
        private function onMouseUp(e:MouseEvent):void {
            stopDrag();
            drag = false;
            removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function chageBasePoint():void {
            var dx:Number = mouseX - basePoint.x;
            var dy:Number = mouseY - basePoint.y;
            
            //図形位置を変更
            shape.x -= dx;
            shape.y -= dy;
            
            //基点を変更
            var nextPoint:Point = this.localToGlobal( new Point( mouseX, mouseY ) );
            this.x = nextPoint.x;
            this.y = nextPoint.y;
            
            //目標角度を計算
            var angle:Number = Math.atan2( shape.y, shape.x );
            targetAngle = 90 - (180 / Math.PI ) * angle;
        }
        
    }
