/**
 * Copyright ug24k8 ( http://wonderfl.net/user/ug24k8 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yAtZ
 */

// forked from yawakisin's Papervision3d入門 2.5.2
/*
	Flash3D コンテンツ制作のためのPapervision3Dのサンプルテスト	
	
	code 3.2.3
*/

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.net.*;
	import flash.system.*;
	import org.papervision3d.view.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.primitives.*;
	
	public class Sample extends BasicView {
		
		private var loader:Loader;

		// コンストラクタ
		public function Sample() 
		{
			// Loaderクラスを使用して画像ファイルを読み込む(外部のパスを指定)
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, compHandler);
			loader.load(
				new URLRequest("http://assets.wonderfl.net/images/related_images/2/29/2957/295773efe549b4206f0ab5e4e776915fb02f95ff"),
				new LoaderContext(true));		
		}
		
		private function compHandler(e:Event):void 
		{
			// 画像ファイルを読み込んだ場合、loaderのcontentプロパティがビットマップ画像になっている
			var bmpData:BitmapData = Bitmap(loader.content).bitmapData;
//                         ↑ どっちでもいいみたいね ↓
//			var bmpData:BitmapData = new BitmapData(loader.width, loader.height);
//			bmpData.draw(loader);

			// マテリアルを作成
			var material:BitmapMaterial = new BitmapMaterial(bmpData);
			
			// 球体(Sphere)を作成
			// 引数はマテリアル、球面の半径、横のポリゴン分割数、縦のポリゴン分割数
			var sphere:Sphere = new Sphere(material, 500, 15, 15);
			
			// 3D空間に球体を追加
			scene.addChild(sphere);
			
			// レンダリング
			startRendering();

			// エンターフレームのイベントを登録
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		// アニメーション
		private function loop(e:Event):void 
		{
		}
	}
}
