/**
 * Copyright bremen.propeller ( http://wonderfl.net/user/bremen.propeller )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yAro
 */

// forked from sakef's パーリンノイズ勉強 水面
package
{
    import net.wonderfl.utils.SequentialLoader;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]
    public class Main extends Sprite
    {
        private static const IMG_URL:String = "http://assets.wonderfl.net/images/related_images/d/dd/ddaf/ddaf70f0881616c4ce0bd9e4122b6d75aecc3745";
        
        private var imgs:Array;
        private var source:BitmapData;
        private var dest:BitmapData;
        private var perlinBmpd:BitmapData;
        private var seed:Number;
        private var offset:Array;
        
        public function Main()
        {
            imgs=[];
            SequentialLoader.loadImages([IMG_URL], imgs, onLoaded);
        }
        
        public function onLoaded():void
        {
            // 画像の読み込み
            var ldr:Loader=imgs.pop();
            source = (ldr.content as Bitmap).bitmapData;    
            dest = new BitmapData(source.width, source.height, false, 0x000000);
            perlinBmpd = new BitmapData(source.width, source.height, false, 0x000000);
            addChild(new Bitmap(dest));
            
            // パーリンノイズ用
            seed=Math.floor(Math.random() * 10);
            offset=[new Point(0, 0), new Point(0, 0)];
            
            // 画像を暗くする
            source.colorTransform(source.rect, new ColorTransform(0.5, 0.5, 0.5));
            
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        // パーリンノイズと水面生成
        private function onFrame(e:Event):void
        {
            perlinBmpd.perlinNoise(source.width *0.5, source.height *0.5, 2, seed, false, true, BitmapDataChannel.RED, false, offset);
            dest.applyFilter(source, source.rect, new Point,new DisplacementMapFilter(perlinBmpd, new Point, BitmapDataChannel.RED, BitmapDataChannel.RED, 50, 50, DisplacementMapFilterMode.CLAMP));
            offset[0].x+=10;
            offset[1].y+=10;
        }
    }
} 
