/**
 * Copyright o8que ( http://wonderfl.net/user/o8que )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yAi1
 */

// forked from bkzen's MoviePuzzleTest
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * [企画]皆で動くパズル作ろうぜ
     * http://wonderfl.net/c/yb0z
     * 前から気になってた事があって、Wonderfl は色んな作品があるけど作品同士のつながりがないのが気になっていた。
     * 例えば、パーツだけ作って読み込んでロードするだけで使える[素材]を作るとか。
     * あと Fork することで何かに参加できるようにすればもっと面白い事になって行きそうなきがする。
     * チェックメイトやJAMのような方法ではなく、Forkされたもの全てが一つの作品を作るというか。
     * これからもチェックメイトやJAM以外にも[企画]タグや[素材]タグが増えていくといいなぁ。
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0x000000", frameRate = "60", width = "465", height = "465")]
    public class MoviePuzzle extends Sprite 
    {
        private static const BG_COLOR: uint = 0x000000;
        private static const FRAME_RATE: uint = 30;
        
        public function MoviePuzzle() 
        {
            // ローダーで読み込まれなかった時の為のデモ用
            addEventListener(Event.ADDED_TO_STAGE, demo);
        }
        
        /**
         * 
         * MoviePuzzle -> MovieJigsawPuzzle
         *         obj["disp"]      : DisplayObject : 描画対象このオブジェクトの440x440の範囲で切り取られて描画されます。
         *         obj["color"]     : uint : 背景色(省略時は0x000000)
         *         obj["frameRate"] : uint : フレームレート(省略時は60)
         *         obj["level"]     : uint : 上限レベル(省略時は1)
         * @param    obj : <Object>
         */
        public function initialize(obj: Object): void
        {
            disp = new ColorTable();
            obj["disp"]  = disp;
            obj["color"] = BG_COLOR;
            obj["frameRate"]  = FRAME_RATE;
        }
        
        /**
         * スタートする時に呼ばれます。
         * @param    level : uint : 指定レベル : 変える必要があれば。
         */
        public function start(level: uint): void
        {
            Object(disp).start(level);
        }
        
        /**
         * 終了した時に呼ばれます。
         */
        public function end(): void
        {
            Object(disp).end();
        }
        
        private var disp: DisplayObject;
        
        /**
         * デモ用
         * @param    e
         */
        private function demo(e: Event): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, demo);
            //
            var obj: Object = {};
            initialize(obj);
            disp = obj["disp"];
            var col: uint = obj["color"];
            var bmd: BitmapData = new BitmapData(440, 440, false, col);
            var bmp: Bitmap = new Bitmap(bmd, "auto", true);
            start(1);
            addChild(bmp);
            addEventListener(Event.ENTER_FRAME, function(e: Event): void {
                bmd.lock();
                bmd.fillRect(bmd.rect, col);
                bmd.draw(disp);
                bmd.unlock();
            } );
        }
    }
}
//package {
    import flash.display.Sprite;
    
    //public 
    class ColorTable extends Sprite {
        
        public function ColorTable() {
            var colors:Array = [
                0xff0000, 0x00ff00, 0x0000ff,
                0x880000, 0x008800, 0x000088,
                0xffff00, 0xff00ff, 0x00ffff,
                0x888800, 0x880088, 0x008888,
                0xff8888, 0x88ff88, 0x8888ff,
                0x000000
            ];
            shuffleArray(colors);
            
            drawTile(0, 0, 8, 8, colors[0]);
            drawTile(1, 1, 2, 2, colors[1]);
            drawTile(3, 1, 2, 2, colors[2]);
            drawTile(5, 1, 2, 2, colors[3]);
            drawTile(1, 3, 2, 2, colors[4]);
            drawTile(3, 3, 2, 2, colors[5]);
            drawTile(5, 3, 2, 2, colors[6]);
            drawTile(1, 5, 2, 2, colors[7]);
            drawTile(3, 5, 2, 2, colors[8]);
            drawTile(5, 5, 2, 2, colors[9]);
            drawTile(1, 0, 2, 1, colors[10]); drawTile(0, 5, 1, 2, colors[10]);
            drawTile(3, 0, 2, 1, colors[11]); drawTile(0, 3, 1, 2, colors[11]);
            drawTile(5, 0, 2, 1, colors[12]); drawTile(0, 1, 1, 2, colors[12]);
            drawTile(1, 7, 2, 1, colors[13]); drawTile(7, 1, 1, 2, colors[13]);
            drawTile(3, 7, 2, 1, colors[14]); drawTile(7, 3, 1, 2, colors[14]);
            drawTile(5, 7, 2, 1, colors[15]); drawTile(7, 5, 1, 2, colors[15]);
        }
        
        private function shuffleArray(array:Array):void {
            for (var i:int = array.length - 1, j:int, tmp:*; i > 0; i--) {
                tmp = array[i];
                array[i] = array[j = int((i + 1) * Math.random())];
                array[j] = tmp;
            }
        }
        
        private function drawTile(x:int, y:int, width:int, height:int, color:uint):void {
            graphics.beginFill(color);
            graphics.drawRect(55 * x, 55 * y, 55 * width, 55 * height);
            graphics.endFill();
        }
        
        public function start(level:uint):void { }
        public function end():void { }
    }
//}