/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yA2U
 */

package  
{
    
    import flash.display.Sprite;
    import flash.events.Event;
    /**
     * ...
     * @author umhr
     */
    public class WonderflMain extends Sprite 
    {
        
        public function WonderflMain() 
        {
            init();
        }
        private function init():void 
        {
            if (stage) onInit();
            else addEventListener(Event.ADDED_TO_STAGE, onInit);
        }
        
        private function onInit(event:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, onInit);
            // entry point
            
            
            addChild(new Canvas());
            
        }
    }
    
}

    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    /**
     * ...
     * @author umhr
     */
    class Canvas extends Sprite 
    {
        private var _panelList:Vector.<Shape> = new Vector.<Shape>();
        private var _panels:Sprite = new Sprite();
        public function Canvas() 
        {
            init();
        }
        private function init():void 
        {
            if (stage) onInit();
            else addEventListener(Event.ADDED_TO_STAGE, onInit);
        }
        
        private function onInit(event:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, onInit);
            // entry point
            
            var lcd:LCD = new LCD();
            lcd.x = stage.stageWidth*0.5;
            lcd.y = stage.stageHeight*0.5;
            lcd.z = 100;
            addChild(lcd);
            
            _panels = new Panel();
            _panels.x = stage.stageWidth*0.5;
            _panels.y = stage.stageHeight*0.5;
            _panels.z = 0;
            addChild(_panels);
            
            addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        
        private function enterFrame(e:Event):void 
        {
            var rY:Number = (mouseX - stage.stageWidth * 0.5) * 0.1;
            var rX:Number = -(mouseY - stage.stageHeight * 0.5) * 0.1;
            _panels.rotationX = rX * 0.05 + _panels.rotationX * 0.95;
            _panels.rotationY = rY * 0.05 + _panels.rotationY * 0.95;
            
        }
    }
    
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    /**
     * ...
     * @author umhr
     */
    class Panel extends Sprite 
    {
        public function Panel() 
        {
            init();
        }
        private function init():void 
        {
            if (stage) onInit();
            else addEventListener(Event.ADDED_TO_STAGE, onInit);
        }
        
        private function onInit(event:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, onInit);
            // entry point
            
            var n:int = 2;
            for (var i:int = 0; i < n; i++) 
            {
                var panel:Shape = getPanel(i);
                
                panel.z = 50 * i;
                addChild(panel);
            }
            
        }
        private function getPanel(index:int):Shape {
            
            var panel:Shape = new Shape();
            panel.graphics.beginFill(0xFF0000, 0.5);
            
            var size:int = 20;
            
            var n:int = 400 / size;
            for (var i:int = 0; i < n; i++) 
            {
                var m:int = 400 / size;
                for (var j:int = 0; j < m; j++) 
                {
                    if ((i % 2 + j +index) % 2 == 1) {
                        continue;
                    }
                    panel.graphics.drawRect(size * j - 200, size * i - 200, size, size);
                }
            }
            
            panel.graphics.endFill();
            return panel;
        }
    }
    
    
    import flash.display.Sprite;
    import flash.events.Event;
    /**
     * ...
     * @author umhr
     */
    class LCD extends Sprite 
    {
        
        public function LCD() 
        {
            init();
        }
        private function init():void 
        {
            if (stage) onInit();
            else addEventListener(Event.ADDED_TO_STAGE, onInit);
        }
        
        private function onInit(event:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, onInit);
            // entry point
            
            graphics.beginFill(0xFFFFFF);
            graphics.drawRect(-200, -200, 400, 400);
            graphics.endFill();
            
        }
    }
    
