/**
 * Copyright _ueueueueue ( http://wonderfl.net/user/_ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y9zP
 */

package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.GlowFilter;
    import flash.geom.*;
    import flash.text.*;
    import flash.ui.*;
    
    [SWF(width=465,height=465,backgroundColor=0x0)]
    
    /**
     * ...
     * @author ue
     */
    
    public class Main extends Sprite 
    {
        private const NUM:int = 100;
        
        private var _canvas:BitmapData;
        private var _min:Number = 50;
        private var _angle:Number = 0;
        private var _shapes:Vector.<Shape> = new Vector.<Shape>(NUM, true);
        
        public function Main():void 
        {
            for (var i:int = 0; i < NUM; i++) 
            {
                var shape:Shape = new Shape();
                shape.graphics.beginFill(0xFFFFFF);
                shape.graphics.drawCircle(0, 0, 1);
                shape.x = (Math.random()+Math.random())/2 * stage.stageWidth;
                shape.y = (Math.random()+Math.random())/2 * stage.stageHeight;
                shape.graphics.endFill();
                addChild(shape);
                _shapes[i] = shape;
            }
            
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void 
        {    
            graphics.clear();
            for (var i:int = 0; i < NUM; i++) 
            {
                var shapeA:Shape = _shapes[i] as Shape;
                shapeA.x += Math.random()-0.5;
                shapeA.y += Math.random()-0.5;
                
                if (shapeA.x > stage.stageWidth) shapeA.x = 0;
                else if (shapeA.x < 0) shapeA.x = stage.stageWidth;
                if (shapeA.y > stage.stageHeight) shapeA.y = 0;
                else if (shapeA.y < 0) shapeA.y = stage.stageHeight;
                
                for (var j:int = i + 1; j < NUM; j++)
                {
                    var shapeB:Shape = _shapes[j] as Shape;
                    var dx:Number = shapeB.x - shapeA.x;
                    var dy:Number = shapeB.y - shapeA.y;
                    var dist:Number = Math.sqrt(dx * dx + dy * dy);
                    if (dist < _min)
                    {
                        graphics.lineStyle(0.5, 0xFFFFFF, 1 - dist / _min -0.2);
                        graphics.moveTo(shapeA.x, shapeA.y);
                        graphics.lineTo(shapeB.x, shapeB.y);
                    }
                }
            }
            _angle += 0.05;
            _min = Math.sin(_angle) * 50 + 50;
        }
    }
}