/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y9qE
 */

// forked from siouxcitizen's Away3D練習6　Torus表示
// forked from siouxcitizen's Away3D練習5　Shading&Phong Color MaterialでCone表示
// forked from siouxcitizen's Away3D練習4　3種類のMaterialでCube表示
// forked from siouxcitizen's Away3D練習3　3種類のMaterialでSphere表示
// forked from siouxcitizen's Away3D練習2　3種類のMaterialでPlane表示
// forked from siouxcitizen's Away3D練習1　Plane表示
// forked from siouxcitizen's forked from: Away3Dの練習
// forked from ser1zw's Away3Dの練習
//
//以下のサイトと自分作成の昔のコードを参考にしました
//サイト
//Away3D Basics 6 - Bitmap materials
//http://www.flashmagazine.com/tutorials/detail/away3d_basics_6_-_bitmap_materials//
//自分作成の昔のコード
//http://wonderfl.net/c/gjEW

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Vector3D;

    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.display.BitmapData;

    import away3d.containers.View3D;
    import away3d.primitives.Plane;
    import away3d.materials.ColorMaterial;
    import away3d.materials.BitmapMaterial;
    import away3d.materials.CompositeMaterial;

    [SWF(frameRate="60", backgroundColor="#ffffff")]
    public class Away3DTest extends Sprite {
        private var view:View3D;
        private var plane:Plane;
    
        public function Away3DTest() {
            view = new View3D();
            view.x = stage.stageWidth >> 1;
            view.y = stage.stageHeight >> 1;
            addChild(view);

            //表示するテキストの書体
            var font:String = "";
            //表示するテキストのサイズ
            var size:int = 200;
            //表示するテキストの色
            var fontColor:uint = 0x1A2630;
            //表示するテキストの背景色
            var bgColor:uint = 0x0068B4;
            //テキストデータ設定
            var format:TextFormat;
            format = new TextFormat(font, size, fontColor);
            var tf:TextField = new TextField();
            tf.defaultTextFormat = format;
            tf.text = "( ﾟДﾟ)";
            tf.autoSize = TextFieldAutoSize.LEFT;

            //テキストデータからBitmapデータを設定
            var bd:BitmapData = new BitmapData(tf.width, tf.height, true, 0xF);
            bd.draw(tf);

            var bitmapMaterial:BitmapMaterial = new BitmapMaterial(bd);
            
            plane = new Plane({width: 150, height: 150});
            plane.material = bitmapMaterial;
            plane.bothsides = true;
            plane.rotationX = -90;
            view.scene.addChild(plane);

            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        private function onEnterFrame(e:Event):void {
            plane.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            plane.rotationY = stage.mouseX - (stage.stageWidth >> 1);
            view.render();
        }
    }
}
            