/**
 * Copyright Etienne.Verhote ( http://wonderfl.net/user/Etienne.Verhote )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y9mH
 */

// forked from mousman's dynamic text with fire particles
package  
{
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.errors.ScriptTimeoutError;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BitmapFilterType;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.filters.GradientGlowFilter;
    import flash.geom.ColorTransform;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    /**
     * ...
     * @author mousman
     */
     [SWF(width="460", height="460", backgroundColor="0x0", frameRate="30")]
    public class Main extends Sprite 
    {
        private var _fire:FireParticules;
        private var _width:Number = 460;
        private var _height:Number = 460;    
        private var _attractor:Sprite;
        private var _timer:Timer;        
        
        public function Main() 
        {
            _fire = new FireParticules();
            addChild(_fire);
            _fire.start();
            
            setAtractor("10");
            _timer = new Timer(3000);
            _timer.addEventListener(TimerEvent.TIMER, timerHandler);
            _timer.start();            
        }
        
        private function timerHandler(e:TimerEvent):void 
        {
            var text:String = (_timer.currentCount+10).toString();   
            setAtractor(text);
        }
        
        
        private function setAtractor(txt:String):void {
            _attractor = new Sprite();
            var bg:Shape = new Shape();
            bg.graphics.beginFill(0);
            bg.graphics.drawRect(0, 0, _width, _height);
            bg.graphics.endFill();            
            _attractor.addChild(bg);

            var texte:TextField = new TextField();
            //texte.autoSize = "center";
            //texte.width = 150;
            var textFormat:TextFormat;
            textFormat = new TextFormat();
            textFormat.font = "Arial";
            textFormat.size = 100;
            textFormat.bold = true;
            texte.defaultTextFormat = textFormat;    
            texte.text = txt;
            
            texte.scaleX = 4;
            texte.scaleY = 3;
            
            var colors:Array = [0x0000ff, 0x0000ff];
            var alphas:Array = [0, 1];
            var ratios:Array = [0, 255];
            var blurX:Number = 24;
            var blurY:Number = 24;
            var strength:Number = 1;
            var type:String = BitmapFilterType.OUTER;
            var quality:int = BitmapFilterQuality.HIGH;
            
            var filter:GradientGlowFilter= new GradientGlowFilter(0,0,colors,alphas,ratios,blurX,blurY,strength,quality,type);
            texte.filters = [filter];
            
            texte.x = 30;
            texte.y = 30;
            _attractor.addChild(texte);
            
            _fire.addAttractor(_attractor as DisplayObject);
        }        
        
    }
}

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.events.Event;
    
    class FireParticules extends Sprite {
        private var bmpdata:BitmapData;
        private var colortrans:ColorTransform;
        private var filter:BlurFilter;
        private var vectormap:BitmapData;
        private var particles:Vector.<Particle>;
        private var particle_number:uint = 30000;
        private var _width:Number = 460;
        private var _height:Number = 460;
        private var compteur:int = 0;        
        private var perlincpt:int = 0;        
        private var _flux:int = 10;        
        private var _ratio:int = 8;   
        private var _rx:int = 16;   
        private var _ry:int = 16;   
        private var _pColor:int = 0xE5AF64;
        private var _blurX:int = 8;
        private var _blurY:int = 12;
        private var _xForce:Number = 0.002;
        private var _yForce:Number = 0.0015;
        private var _attractor:BitmapData;
        
        public function FireParticules() {
        }
        
        public function start():void 
        {
            _attractor = new BitmapData(_width, _height, false, 0x000080);

            bmpdata = new BitmapData( _width, _height, false, 0);
            addChild( new Bitmap(bmpdata));
            colortrans = new ColorTransform( 0.96, 0.85, 0 );
            filter = new BlurFilter( _blurX, _blurY, 1);
            vectormap = new BitmapData( _width, _height, false, 0);
            reset();
            addEventListener( Event.ENTER_FRAME, enterframe);
        }
        
        private function reset():void {
            var randomSeed:int = Math.random() * 0xFFFFFFFF;
            var colors:uint = BitmapDataChannel.RED | BitmapDataChannel.GREEN;
            setPerlin();               
            particles = new Vector.<Particle>(particle_number,true);
            for( var i:int = 0; i < 20000; i++){
                particles[i] = new Particle(Math.random()*_width,startY);                    
            }
            compteur = 20000;
        }
        
          private function setPerlin():void {
            var pX:int;
            var pY:int;
            var randomSeed:int = Math.random() * 0xFFFFFFFF;
            var colors:uint = BitmapDataChannel.RED | BitmapDataChannel.GREEN;
            vectormap.perlinNoise( _width / _rx, _height / _ry, _ratio, randomSeed, true, false, colors);
        } 
        
        private function enterframe(e:Event):void {
            bmpdata.colorTransform( bmpdata.rect, colortrans);
            bmpdata.lock();
            var nb:int = compteur;
            perlincpt ++;
            
            if (perlincpt / stage.frameRate > 10 ) {
                    setPerlin();
                    perlincpt = 0;
            } 
            
            for( var i:int = 0; i <nb; i++){
                var p:Particle = particles[i];
                
                var perlinColor:uint = vectormap.getPixel( p.x, p.y );
                var attractorColor:uint = _attractor.getPixel( p.x, p.y );
                
                var red:int = ( ( perlinColor >> 16 ) -0x50 );
                
                var green:int = (( perlinColor &  0x00ff00) >> 8) -0x70 ;
                
                var blue:int = (( attractorColor &  0x0000ff) );
                
                p.vx += red * _xForce;
                p.vy += green * _yForce;            
                p.x += p.vx;
                p.y += p.vy;
                
                attractorColor = _attractor.getPixel( p.x, p.y );
                var newBlue:int = (( attractorColor &  0x0000ff) );
                if (newBlue < blue) {
                    p.vx += -Math.abs(p.vx)/p.vx  * newBlue/20;
                    p.vy += -Math.abs(p.vy)/p.vy  * newBlue/20;            
                    p.x += p.vx;
                    p.y += p.vy;                        
                }
                
                else if (newBlue > blue){
                    p.x += Math.abs(p.vx) *2/ p.vx;
                    p.y += Math.abs(p.vy) *2/ p.vy;        
                }
                
                if ( p.x > _width ) {
                    p.vx = 0;
                    p.vy = 0;                            
                    p.x = int( Math.random() * _width);
                    p.y = startY;
                    }
                else if ( p.x < 0 ) { 
                    p.vx = 0;
                    p.vy = 0;                        
                    p.x =  int( Math.random() * _width);
                    p.y = startY;
                    }
                if ( p.y > _height ) { 
                    p.vx = 0;
                    p.vy = 0;                
                    p.x =  int( Math.random() * _width);
                    p.y = startY; 
                }
                else if ( p.y < 0 ) {
                    p.vx = 0;
                    p.vy = 0;                      
                    p.x =  int( Math.random() * _width);
                    p.y = startY; 
                }
                
                bmpdata.setPixel( p.x, p.y, _pColor );
            }
            
            if (compteur < particle_number) {
                var flux:int = ( (compteur + _flux) > particle_number ) ? particle_number-compteur:_flux; 
                for ( var j:int = compteur; j < (compteur + flux); j++) {
                    particles[j] = new Particle(Math.random() * _width, startY);        
                }
                compteur += flux;
            }                
            bmpdata.applyFilter( bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter);                
            bmpdata.unlock()
        }

        
        public function addAttractor(dO:DisplayObject):void {
            _attractor = new BitmapData(_width, _height, false, 0x000000);
            _attractor.draw(dO);
        }
        
        public function removeAttractor():void {
            _attractor = new BitmapData(_height, _height, false, 0x000080);
        }
        
        private function get startY():int {
            var value:int = _height-50;
            return value;
        }


    }

    class Particle{
        public var x:Number;
        public var y:Number;
        public var ax:Number = 0;
        public var ay:Number = 0;
        public var vx:Number = 0;
        public var vy:Number = 0;
    
        function Particle( px:Number, py:Number){
            x = px;
            y = py;
        }

    }