/**
 * Copyright yes_i_can ( http://wonderfl.net/user/yes_i_can )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y8mM
 */

// forked from yes_i_can's forked from: [PV3D] Simple Sphere
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.utils.*;
	import flash.net.*;
	import flash.filters.*;
	import flash.text.*;
	import flash.ui.Keyboard;
 
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.objects.*;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.*;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.lights.*;

	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.objects.primitives.Sphere;

 
	public class main_test extends Sprite
	{
		private var viewport:Viewport3D;
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var renderer:BasicRenderEngine;
		private var sphere:Sphere;

		var keyRight    :Boolean = false;
		var keyLeft     :Boolean = false;
		var keyForward  :Boolean = false;
		var keyBackward :Boolean = false;
		
		
		//main
		public function main_test()
		{
			stage.quality = StageQuality.LOW;

			this.addEventListener(Event.ENTER_FRAME, loop3D);
			stage.addEventListener( KeyboardEvent.KEY_DOWN, onKeyDownHandler );
			init3D();
		}
			
		//init3D			
		private function init3D():void
		{
			// 基本設定
			viewport = new Viewport3D(stage.width, stage.height, true, false);
			addChild(viewport);
			setChildIndex(viewport,0);
		 	setLight();
			
			scene = new Scene3D();
			camera = new Camera3D();
			renderer = new BasicRenderEngine();
			
			// カメラの設定
			camera.y  = 200;

			// 球面のポリゴンに貼り付けるテクスチャ(フラットポリゴンを使用)を作成します
			// 引数はライト、明るい部分の色、暗い部分の色です。
			var material:FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFFFF, 0x000000);
			
			// 球面を作成(引数はテクスチャ、半径、横方向のポリゴン分割数、縦方向のポリゴン分割数)
			sphere = new Sphere(material, 200, 12, 12);
			
			// 3Dシーンに表示(PV3DではsceneにaddChildします)
			scene.addChild(sphere);
			
		}


		// loop3D
		private function loop3D(event:Event):void
		{
			updateObject();
			updateCamera();
			renderer.renderScene(scene, camera, viewport);
		}

		
		//オブジェクトの移動
		function updateObject():void
		{
			if ( keyLeft ){
				sphere.rotationY -= 10;
			}
		
			if ( keyRight ){
				sphere.rotationY += 10;
			}
		
			if ( keyForward ){
				sphere.moveForward(10);
			}
		
			if ( keyBackward ){
				sphere.moveForward(-10);
			}
			
		}


		//カメラの移動
		function updateCamera():void {
				camera.target = sphere;
				camera.x = sphere.x;
				camera.y = sphere.y + 100;
				camera.z = sphere.z;
		}
		

		//Keyboard
		function onKeyDownHandler( event :KeyboardEvent ):void {
			switch ( event.keyCode ) {
				case Keyboard.UP :
					keyForward = true;
					break;
		
				case Keyboard.DOWN :
					keyBackward = true;
					break;
		
				case Keyboard.LEFT :
					keyLeft = true;
					break;
		
				case Keyboard.RIGHT :
					keyRight = true;
					break;
			}
		}


		//setlight
		function setLight():void 
		{
			light = new PointLight3D(false);
			light.x = 1000;
			light.y = 500;
			light.z = 1000;
		}
	 
	}
}