/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y8dv
 */

package {



    import flash.display.MovieClip ;

    import flash.events.Event;
 
    import flash.display.Sprite;



    public class DocumentClass extends MovieClip { 

        // private properties 

        private const NUMPOINTS:int = 60;                    // number of points on sphere

        public const FL:int = 500;                            // 3D Perspective focal length

        private var _itemArray:Array = new Array();            // hold reference to all clips on stage

        private var _speed:Number = 0.5;                    // camera speed

        

        public var centerX:Number = stage.stageWidth/2;        // Stage Center X

        public var centerY:Number = stage.stageHeight/2;    // Stage Center Y

        public var centerZ:Number = FL*2;                    // Stage center Z

        public var oCamera:Object = new Object();            // virtual 3D camera object

        

        // MOUSE position

        public var rotX:Number=0;

        public var rotY:Number=0;

        

        // Constructor

        public function DocumentClass() {

            

            // Set initial camera Properties  

            oCamera.x = 0;            // target camera x position        

            oCamera.y = 0;            // target camera y position                

            oCamera.z = 500;          // target camera z position

            oCamera.dz = 0;            // initial camera z position    

            oCamera.dx = 0;            // initial camera x position                            

            oCamera.dy = 0;            // initial camera y position                    

            

            // set number of increments 

            var angleIncriment = NUMPOINTS/360;        //space in degrees between items

            

            //--> create sphere shape from circle clips        

            // create the sphere x axis

            for(var i=-Math.PI;i<=Math.PI;i+=angleIncriment ){

                // create the sphere y axis

                for(var j=0;j<=Math.PI;j+=angleIncriment){

                        // create object from library

                        var mcClip:Circle= new Circle(this,i,j);

                        // add to stage

                        addChild(mcClip);

                        // add to array

                        _itemArray.push(mcClip);

                }

            }

            

            // listen to enterFrame event

            addEventListener(Event.ENTER_FRAME, onEnterFrame);

            

        }

        

        private function onEnterFrame(event:Event):void{

                // Set mouse position coordinates

                rotX += ((mouseY-centerY)/100);

                rotY += ((mouseX-centerX)/100);

                oCamera.z += ((mouseY-centerY)/50);

                

                // Move Camera

                oCamera.dz -= (oCamera.dz-oCamera.z)*_speed;            

                oCamera.dx -= (oCamera.dx-oCamera.x)*_speed;            

                oCamera.dy -= (oCamera.dy-oCamera.y)*_speed;        



                // place elements of sphere in 3D space

                for (var i in _itemArray){

                    _itemArray[i].renderRotate();

                }

        }

    }

    

    public class Circle extends Sprite {

        

        private var _path:Object;                            // reference to Document Class

        private const PIRAD:Number = Math.PI / 180;            // radian conversion multiplier        

        

        // clip 3d point properties

        private var _x:Number;

        private var _y:Number;

        private var _z:Number;

        private var _dx:Number;

        private var _dy:Number;

        private var _dz:Number;    

        private var __z:Number;

        

        public function Circle(obj:Object,i:Number,j:Number){

            

            // reference to path

            _path = obj;

                

            //set 3D properties and positions

            _x = _path.centerX + Math.cos(i) * Math.cos(j)*_path.FL;

            _y = _path.centerY + Math.cos(i) * Math.sin(j)*_path.FL;

            __z = _z = _path.centerY + Math.sin(i)*_path.FL;

        }

        

        //--> degrees to radials

        public function renderRotate():void{



                // convert slider settings to radians

                var rX    = _path.rotX*3.6 * PIRAD;        

                var rY    = _path.rotY*3.6 * PIRAD;

                var rZ    = 0*3.6 * PIRAD;

                

                //--> rotate around y-axis                

                var tempX = (_x * Math.cos(rY)) - (_z * Math.sin(rY));

                var tempZ = (_x * Math.sin(rY)) + (_z * Math.cos(rY));



                //--> rotate around x-axis        

                _dz = (tempZ * Math.cos(rX)) - (_y * Math.sin(rX));

                var tempY = (tempZ * Math.sin(rX)) + (_y * Math.cos(rX));



                //--> rotate around z-axis

                _dx = (tempX * Math.cos(rZ)) + (tempY * Math.sin(rZ));

                _dy = (tempY * Math.cos(rZ)) - (tempX * Math.sin(rZ));



                //-->  Convert 3D to 2D;

                // --- scale ---

                // Calculating actual scale values according to scale = fl/(z+fl) formula

                var scale = _path.oCamera.dz /(_path.oCamera.dz + __z);



                // clip 3D position

                x    = _path.centerX + (_path.oCamera.dx + _dx * scale);

                y    = _path.centerY + (_path.oCamera.dy + _dy * scale);

                __z = _path.centerZ + (_path.oCamera.dz + _dz * scale);

                

                // transparency

                alpha = (_path.oCamera.dz-(_dz * scale))/100;

        }

        

    }

}







/*

________________________________________________



2007, All rights reserved

Paul Ortchanian San Francisco CA

paul@reflektions.com



This code is free; you can redistribute it and/or modify

it under the terms of the GNU General Public License as 

published by the Free Software Foundation.



________________________________________________



*/