/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y8JY
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.*;
    import flash.media.*;
    import flash.net.*;
    import flash.system.*;
    import com.bit101.components.*;

    public class Test extends Sprite {
        private var _tf : TextField;
        private var _sound : Sound;
        private const URL : String = "http://dl.dropbox.com/u/5742517/ieaaaaaaaa.mp3";
        private var _text : InputText;
        private var _submit : PushButton;

        public function Test() {
            _tf = new TextField();
            _tf.y = 30;
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf); 

            _text = new InputText(this, 0, 0);
            _text.width = 200;
            
            _submit = new PushButton(this, 200, 0, "submit", function(e:MouseEvent) : void
            {
                _sound = new Sound();
                _sound.addEventListener(Event.COMPLETE, onComplete);
                _sound.addEventListener(IOErrorEvent.IO_ERROR, onIOError);
                _sound.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onSecurityError);
                _sound.addEventListener(ProgressEvent.PROGRESS, onProgress);
                _sound.load(new URLRequest(_text.text));
            });
        }
        
        private function removeEvents() : void
        {
            _sound.removeEventListener(Event.COMPLETE, onComplete);
            _sound.removeEventListener(IOErrorEvent.IO_ERROR, onIOError);
            _sound.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, onSecurityError);
            _sound.removeEventListener(ProgressEvent.PROGRESS, onProgress);
        } 

        private function onIOError(e : ErrorEvent) : void
        {
            removeEvents();
            tr(e);
        }

        private function onSecurityError(e : ErrorEvent) : void
        {
            removeEvents();
            tr(e);
        }

        private function onProgress(e : ProgressEvent) : void
        {
            tr(e.bytesLoaded, e.bytesTotal);
        }

        private function onComplete(e : Event) : void
        {
            removeEvents();
            tr(_sound.length);
            _sound.play();
        }


        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
        }
    }
}