/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y8Ch
 */

// forked from Scmiz's flash on 2011-4-10
package {
    import flash.events.Event;
    import flash.display.Sprite;
    import caurina.transitions.Tweener;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.GouraudMaterial;

    public class FlashTest extends Sprite {
        private var _view:BasicView;
        
        public function FlashTest() {
			this.graphics.beginFill(0x000000);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();
			
            _view = new BasicView(465, 465);
            _view.camera.zoom = 50;
            this.addChild(_view);            
            
            var container:DisplayObject3D = new DisplayObject3D();
            container.rotationX = -35;
            _view.scene.addChild(container);

            var light:PointLight3D = new PointLight3D(false);
            light.x = 500;
            light.y = 300;
            light.z = -100;
            container.addChild(light);
			
			var cubes:DisplayObject3D = new DisplayObject3D();
			container.addChild(cubes);

            var matG:GouraudMaterial = new GouraudMaterial(light, 0x20d020);
            var matB:GouraudMaterial = new GouraudMaterial(light, 0xb08020);
            var materials:MaterialsList = new MaterialsList();
            materials.addMaterial(matG, "top");
            materials.addMaterial(matB, "bottom");
            materials.addMaterial(matB, "left");
            materials.addMaterial(matB, "right");
            materials.addMaterial(matB, "front");
            materials.addMaterial(matB, "back");
            
            var width:uint = 16;
            var height:uint = 16;
			
			var x:uint = 0;
			var z:uint = 0;
			
			var map:Array = new Array();
            for (z = 0; z < height; ++z) {
                map.push(new Array());
                for (x = 0; x < width; ++x) {
					map[z].push(uint(Math.random() * 4) * 2 + 8);
				}
			}
			
            var cubeArray:Array = new Array();
            for (z = 0; z < height; ++z) {
                cubeArray.push(new Array());
                for (x = 0; x < width; ++x) {
                    var size:Number = 35;
					var h:Number = 5 * map[z][x];
                    var cube:Cube = new Cube(materials, size, size, h, 1, 1, 1);
                    cube.x = -(size * (width / 2)) + (x * size);
					cube.y = 0.5 * h;
                    cube.z = -(size * (height / 2)) + z * size;
                    cubes.addChild(cube);
                    cubeArray[z].push(cube);
                }
            }

            _view.startRendering();

            var proc:Function = function(e:Event):void {
				cubes.rotationY += 1;
            };
            this.addEventListener(Event.ENTER_FRAME, proc);
        }
    }
}
