/**
 * Copyright gaziya ( http://wonderfl.net/user/gaziya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y86O
 */

package {
    import flash.filters.ColorMatrixFilter;
    import flash.display.BlendMode
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;
    import flash.geom.ColorTransform;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var dataW:int = 100
            var dataH:int = 100
            var texture:BitmapData = new BitmapData(300,300,false)
            var bitmap:Bitmap = new Bitmap(texture)
            bitmap.x=85
            bitmap.y=135
            addChild(bitmap)            
            var bmds:Vector.<BitmapData> = new Vector.<BitmapData>
            for (var i:int=0; i<4; i++) {
                bmds.push(new BitmapData(dataW,dataH, false))
                bitmap = addChild(new Bitmap(bmds[i])) as Bitmap
                bitmap.x = (110)*i+20
                bitmap.y = 10
            }            
            bmds[0].perlinNoise(80, 120, 10, Math.random() * 100, true, true, 0, true)
            bmds[0].colorTransform(bmds[1].rect, new ColorTransform(1.5, 1.5, 1.5, 1, -0x40, -0x40, -0x40))            
            bmds[1].fillRect(bmds[1].rect,0x888888)            
            var vector:Vector3D = new Vector3D
            var matrix:Matrix3D = new Matrix3D
            var  multiplier:Number = 25
            for (var y:int=0; y<dataH; y++) {
                for (var x:int=0; x<dataW; x++) {
                    var height:uint = bmds[0].getPixel(x, y) & 0xFF;
                    vector.x = (height - (bmds[0].getPixel((x + 1) % dataW, y) & 0xFF)) / 0xFF * multiplier;
                    vector.y = (height - (bmds[0].getPixel(x, (y + 1) % dataH) & 0xFF)) / 0xFF * multiplier;
                    vector.y *= -1;
                    vector.z = 0;
                    if (vector.lengthSquared > 1) {
                        vector.normalize();
                    }
                    vector.z = Math.sqrt(1 - vector.lengthSquared);
                    
                    matrix.identity();                    
                    matrix.appendRotation(y / bmds[0].height * 180 - 90, Vector3D.X_AXIS);
                    matrix.appendRotation(x / bmds[0].width * 360, Vector3D.Y_AXIS);
                    vector = matrix.transformVector(vector);
                    
                    bmds[2].setPixel(x, y,
                        (vector.x * 0x7F + 0x80) << 16 |
                        (vector.y * 0x7F + 0x80) << 8 |
                        (vector.z * 0x7F + 0x80)
                    )
                }
            }                        
            bmds[3].applyFilter(bmds[2], bmds[2].rect, bmds[2].rect.topLeft, new ColorMatrixFilter([
                1/3, 1/3, 1/3, 0, 0,
                1/3, 1/3, 1/3, 0, 0,
                1/3, 1/3, 1/3, 0, 0,
                0  ,   0,   0, 1, 0    
            ]))            
            texture.copyPixels(bmds[3],bmds[3].rect, bmds[3].rect.topLeft);
            texture.draw(bmds[1], null, null, BlendMode.MULTIPLY);
            
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
            
            })     
            
        }
    }
}