/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y7uH
 */

// forked from alexskopje's flash on 2016-7-5
package 

{

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.geom.Point;

    import flash.media.Sound;

    import flash.media.SoundChannel;

    import flash.media.SoundLoaderContext;

    import flash.media.SoundMixer;

    import flash.media.SoundTransform;

    import flash.net.URLRequest;

    import flash.system.Security;

    import flash.utils.ByteArray;

    import caurina.transitions.Tweener;

    

    [SWF(width = 465, height = 465, backgroundColor = 0 )]

    public class Main extends Sprite

    {

        private var snd:Sound;

        private var sndChannel:SoundChannel;

        

        private var _container:Sprite;

        private var _len:Number;

        private var _array:Array = [];

        private var _points:Array;

        

        public function Main():void 

        {

            this.graphics.beginFill(0);

            this.graphics.drawRect(0, 0, 465, 465);

            this.graphics.endFill();

            

            Security.allowDomain("takasumi-nagai.com");

            playSound("http://www.takasumi-nagai.com/soundfiles/sound005.mp3");

            

            _points = [];

            

            var _textpoint:TextPointMaker = new TextPointMaker("COOL", 150);

            _points = _textpoint.array;

        }

        

        private function playSound(sndUrl:String):void

        {

            snd = new Sound();

            var context:SoundLoaderContext = new SoundLoaderContext(10,true);

            var req:URLRequest = new URLRequest(sndUrl);

            snd.load(req, context);

            snd.addEventListener(Event.COMPLETE, onComp);

        }

        

        private function onComp(e:Event):void 

        {

            sndChannel=new SoundChannel();

            sndChannel = snd.play(0, 10, new SoundTransform(0.3, 0));

            

            for (var i:int = 0; i < 128; i++)

            {

                var r:RoundRect = new RoundRect();

                r.x = Math.random() * 465;

                r.y = Math.random() * 465;

                addChild(r);

                _array.push(r);

            }

            addEventListener(Event.ENTER_FRAME, loop);

        }

        

        private function loop(event:Event):void 

        {

            var bytes:ByteArray = new ByteArray();

            SoundMixer.computeSpectrum(bytes, false, 0);

            bytes.position = 0;

            

            var data:Number = 0;

            

            for (var i:int = 0; i < _array.length; i++)

            {

                var r:RoundRect = _array[i] as RoundRect;

                var _arr:Array = [];

                var d:Number = bytes.readFloat();

                for (var b:int = 0; b < 4; b++)

                {

                    _arr.push(d * 4);

                }

                

                data += d;

                

                r.step(_arr);

                if(r.x < 0) r.x = stage.stageWidth;

                if(r.x > stage.stageWidth) r.x = 0;

                if(r.y < 0) r.y = stage.stageHeight;

                if(r.y > stage.stageHeight) r.y = 0;

            }

            

            if(data < 0) data = -data;

            

            for (var j:int = 0; j < _points.length; j++)

            {

                if(_array[j] == null) return;

                

                var p:Point = _points[j] as Point;

                var _r:RoundRect = _array[j] as RoundRect;

                

                if (data < 2) {

                    Tweener.addTween(_r, { x:_r.vx, y:_r.vy , time:1 } );

                }else {

                    Tweener.addTween(_r, { x:p.x, y:p.y, time:0 } );

                    _r.XY();

                }

            }

        }

    }

}



import flash.display.LineScaleMode;

import flash.display.Sprite;

import flash.geom.Point;



class RoundRect extends Sprite {

    

    public var _p1:Point;

    public var _p2:Point;

    public var _p3:Point;

    public var _p4:Point;

    

    public var vx:Number;

    public var vy:Number;

    

    private var _sp:Sprite;

    private var _len:int;

    

    public function RoundRect(len:int = 10)

    {

        _len = len;

        

        vx = Math.random() * 465;

        vy = Math.random() * 465;

        

        _p1 = new Point( -_len / 2, -_len / 2);

        _p2 = new Point(_len / 2, -_len / 2);

        _p3 = new Point(_len / 2, _len / 2);

        _p4 = new Point( -_len / 2, _len / 2);

        

        _sp = new Sprite();

        _sp.graphics.beginFill(0xFFFFFF);

        _sp.graphics.lineStyle(1, 0, 1, false, LineScaleMode.NONE);

        _sp.graphics.moveTo(_p1.x, _p1.y);

        _sp.graphics.lineTo(_p2.x, _p2.y);

        _sp.graphics.lineTo(_p3.x, _p3.y);

        _sp.graphics.lineTo(_p4.x, _p4.y);

        _sp.graphics.lineTo(_p1.x, _p1.y);

        _sp.graphics.endFill();

        

        _sp.blendMode = "invert";

        

        addChild(_sp);

    }

    

    public function step(_arr:Array):void

    {

        if (_arr == null || _arr.length != 4) return;

        

        var b1:Number = _arr[0];

        var b2:Number = _arr[1];

        var b3:Number = _arr[2];

        var b4:Number = _arr[3];

        

        _sp.graphics.clear();

        //_sp.graphics.beginFill(Math.floor(b1 * 10000));

        _sp.graphics.beginFill(0);

        _sp.graphics.lineStyle(1, 0, 1, false, LineScaleMode.NONE);

        _sp.graphics.moveTo(_p1.x + b1, _p1.y + b1);

        _sp.graphics.lineTo(_p2.x + b2, _p2.y + b2);

        _sp.graphics.lineTo(_p3.x + b3, _p3.y + b3);

        _sp.graphics.lineTo(_p4.x + b4, _p4.y + b4);

        _sp.graphics.lineTo(_p1.x + b1, _p1.y + b1);

        _sp.graphics.endFill();

        

        _sp.scaleX = b1 + b2;

        _sp.scaleY = b3 + b4;

        

        this.rotation += b1 + b2 + b3 + b4;

        this.x += b1 + b2;

        this.y += b3 + b4;

    }

    

    public function XY():void

    {

        vx = Math.random() * 465;

        vy = Math.random() * 465;

    }

}









    import flash.display.Bitmap;

    import flash.display.BitmapData;

    import flash.display.Sprite;

    import flash.geom.Point;

    import flash.text.TextField;

    import flash.text.TextFieldAutoSize;

    import flash.text.TextFormat;

    

    /**

     * ...

     * @author gaina

     */

    

    class TextPointMaker

    {

        private var _array:Array;

        

        public function TextPointMaker(str:String = "VMRO DPMNE", yy:int = 0) 

        {

            var _text:TextField = new TextField();

            _text.text = str;

            _text.autoSize = TextFieldAutoSize.LEFT;

            

            var _textformat:TextFormat = new TextFormat();

            _textformat.size = 31;

            _textformat.font = "Arial";

            _textformat.bold = true;

            

            _text.setTextFormat(_textformat);

            

            var _width:Number = _text.width;

            var _height:Number = _text.height;

            

            var _bitmapdata:BitmapData = new BitmapData(_width, _height, true);

            _bitmapdata.draw(_text);

            

            _array = [];

            

            for (var i:int = 0; i < _height; i += 3) {

                for (var j:int = 0; j < _width; j += 3) {

                    if (_bitmapdata.getPixel(j, i) != 0xFFFFFF) {

                        var s:Point = new Point();

                        s.x = j * 5;

                        s.y = i * 5 + yy;

                        _array.push(s);

                    }

                }

            }

        }

        

        public function get array():Array 

        {

            return _array;

        }

    }