/**
 * Copyright dangerman99 ( http://wonderfl.net/user/dangerman99 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y7qn
 */

// forked from narutohyper's Object3D Drag [Alternativa3D 7.5.1 TIPS]
// forked from narutohyper's Alternativa3D 7.5 Template
package
{
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.materials.TextureMaterial;
    import alternativ7.engine3d.primitives.Box;
    import alternativ7.engine3d.core.MouseEvent3D;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.core.RayIntersectionData;
    import alternativ7.engine3d.objects.Sprite3D;
    import alternativ7.engine3d.core.Object3D;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.Shape;   
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Vector3D;
    
    /**
     *
     * Alternativa3D 7.5
     *
     * Object3DのDrag;
     *
     * ...
     * @author narutohyper
     */
    [SWF(backgroundColor="#555555", frameRate="100", width="800", height="600")]
    public class Main extends Sprite
    {
        
        private const RADIAN:Number = Math.PI / 180;
        
        public function Main():void    {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
           
        }
        
        private function init(e:Event=null):void {
            
                       //This is all the initialization you need in your main class

            
            
            
            
            removeEventListener(Event.ADDED_TO_STAGE, init);
        
            //AlternativaTemplate作成
            var scene:AlternativaTemplate = new AlternativaTemplate(this);

            //Materialの作成

             
            //星パーティクル
            var stars:Vector.<Sprite3D> = new Vector.<Sprite3D>(500, true);
            var circle:Shape = new Shape();
            circle.graphics.beginFill(0xFFFFFF);
            circle.graphics.drawCircle(25, 25, 25);
            var bmd:BitmapData = new BitmapData(50, 50, true, 0);
            bmd.draw(circle);
            var material:TextureMaterial = new TextureMaterial(bmd);
            var angle:Number;
            var length:Number;
            for (var i:int = 0; i < 500; i++)
            {
                stars[i] = new Sprite3D(100, 100, material);
                scene.container.addChild(stars[i]);
                angle = Math.random() * 360 * RADIAN;
                length = Math.random() * 100000 + 5000;
                stars[i].x = Math.cos(angle) * length;
                stars[i].y = Math.sin(angle) * length;
                angle = Math.random() * 360 * RADIAN;
                length = Math.random() * 100000 + 5000;
                stars[i].z = Math.sin(angle) * length;
            }
            
            var material2:FillMaterial = new FillMaterial(0xFFFFFF, 1, 0,0x0);            
            //Box
            box = new Box(200, 200, 200, 2, 2, 2);
            box.name = "Fred";
            box.setMaterialToAllFaces(material2);
            box.addEventListener(MouseEvent3D.MOUSE_DOWN, onMouseDown);
            scene.container.addChild(box);

            //カメラの調整
            //カメラはControllerに関連付けている為、x,y,zで直接位置を指定できないので
            //SimpleController.setObjectPosXYZを使用
            camera = scene.camera;
            cameraContainer = new Object3DContainer();
            cameraContainer.addChild(camera);
            scene.container.addChild(cameraContainer);
            
            cameraController = new SimpleObjectController(stage, cameraContainer, 100);
            cameraController.mouseSensitivity = 1;
            cameraController.unbindAll();
            
            scene.cameraController.setObjectPosXYZ(0, -1000, 0);
            scene.cameraController.lookAtXYZ(0, 0, 0);
            scene.cameraController.mouseSensitivity = 0;
            scene.cameraController.unbindAll();
            scene.cameraController.update();

            view = scene.view;
            
            camera.render();
            //ObjectControllerの作成
            //MouseDragで、Objectを回転させる為のController
            //var objectController:SimpleObjectController = new SimpleObjectController(stage,box,100)
            //objectController.unbindAll()
            
            //描画開始
            scene.startRendering();
            
            
            

            scene.onPreRender = function():void {
                //objectController.update();
                //cameraController.lookAtXYZ(0, 0, 0);
                cameraController.update();
            }
            inittrace(stage);
        }
        
        private var view:View;
        private var cameraContainer:Object3DContainer;
        private var cameraController:SimpleObjectController;
        private var camera:Camera3D;
        private var box:Box;
        private var startPoint:Vector3D;
        private var distance:Number;
        
        private function onMouseDown(e:MouseEvent3D):void
        {       
            
            
            trace(e.target.name);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            box.alpha = 0.5;
            cameraController.mouseSensitivity = 0;
            
            //Objectのclickされた位置を得る
            var tempObject:Object3D = e.target as Object3D;
            var data:RayIntersectionData = tempObject.intersectRay(e.localOrigin, e.localDirection);
            startPoint = data.point;
            
            //cameraから、objectまでの距離を求める
            var origin:Vector3D = new Vector3D;
            var directionA:Vector3D = new Vector3D;
            var directionB:Vector3D = new Vector3D;
            camera.calculateRay(origin, directionA, view.width/2, view.height/2);
            camera.calculateRay(origin, directionB, mouseX, mouseY);

            //cameraとObjectのクリックされた位置までの距離
            var boxPos:Vector3D = new Vector3D(box.x+startPoint.x,box.y+startPoint.y,box.z+startPoint.z);
            distance = Vector3D.distance(boxPos, origin);
            
            //Object3Dまでの距離を、cameraViewのCENTERまで並行移動させた距離
            var radian:Number = Vector3D.angleBetween(directionA, directionB);
            distance = Math.cos(radian) * distance;
            
        }
        
        private function onMouseUp(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            cameraController.mouseSensitivity = 0.5;
            box.alpha = 1;

        }
        
        private function onMouseMove(e:MouseEvent):void
        {
            var origin:Vector3D = new Vector3D;
            var directionA:Vector3D = new Vector3D;
            var directionB:Vector3D = new Vector3D;
            var direction:Vector3D = new Vector3D;
            
            //Object3Dまでの距離を、cameraViewのCENTERまで並行移動させた距離をドラッグ先まで並行移動
            camera.calculateRay(origin, directionA, view.width/2, view.height/2);
            camera.calculateRay(origin, directionB, mouseX, mouseY);
            var radian:Number = Vector3D.angleBetween(directionA, directionB);
            var length:Number=distance/Math.cos(radian);
            direction = new Vector3D(directionB.x * length, directionB.y * length, directionB.z *length);
            var pos:Vector3D = origin.add(direction);
            box.x = pos.x-startPoint.x;
            box.y = pos.y-startPoint.y;
            box.z = pos.z-startPoint.z;
            //cameraController.mouseSensitivity = 0.5;
            trace("test");
        }

    }
    
}



/**
 * BasicTemplate for Alternativa3D 7.5
 * Alternativa3D 7.5を扱いやすくするためのテンプレートです
 * @author narutohyper & clockmaker
 *
 */
import alternativ7.engine3d.containers.BSPContainer;
import alternativ7.engine3d.containers.ConflictContainer;
import alternativ7.engine3d.containers.DistanceSortContainer;
import alternativ7.engine3d.containers.KDContainer;
import alternativ7.engine3d.containers.LODContainer;
import alternativ7.engine3d.controllers.SimpleObjectController;
import alternativ7.engine3d.core.Camera3D;
import alternativ7.engine3d.core.Object3DContainer;
import alternativ7.engine3d.core.View;
import flash.display.DisplayObject;

import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;

import flash.events.Event;

class AlternativaTemplate extends Sprite
{
    /**
     * 子オブジェクトを最適な方法でソートするコンテナ
     * (ConflictContainer)
     */
    public static const CONFLICT:String = 'conflict';
    /**
     * 子オブジェクトをBSP(バイナリ空間分割法)によってソートするコンテナ
     * (BSPContainer)
     */
    public static const BSP:String = 'bsp';
    
    /**
     * 子オブジェクトをカメラからのZ値でソートするコンテナ
     * (DistanceSortContainer)
     */
    public static const ZSORT:String = 'zsort';
    /**
     * KDツリー(http://ja.wikipedia.org/wiki/Kd%E6%9C%A8)によってソートするコンテナ
     * (KDContainer)
     */
    public static const KD:String = 'kd';
    /**
     * detalizationと子オブジェクトの距離でソートするコンテナ（詳細は調査中）
     * (LODContainer)
     */
    public static const LOD:String = 'lod';
    
    /**
     * 3dオブジェクト格納するコンテナインスタンス。
     */
    public var container:Object3DContainer;

    /**
     * ビューインスタンスです。
     */
    public var view:View;
    
    /**
     * カメラインスタンスです。
     */
    public var camera:Camera3D;
    
    /**
     * カメラコントローラーです。
     */
    public var cameraController:SimpleObjectController;
    
    private var _mc:DisplayObjectContainer;
    private var _viewWidth:int;
    private var _viewHeight:int;
    private var _scaleToStage:Boolean;
    private var _containerType:String;
    
    /**
     * 新しい Alternativa3DTemplate インスタンスを作成します。
     * @param    mc
     * @param    containerType
     * @param    viewWidth
     * @param    viewHeight
     * @param    scaleToStage
     */
    public function AlternativaTemplate(mc:DisplayObjectContainer,containerType:String=CONFLICT,viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true)
    {
        
        _mc = mc;
        _mc.addChild(this);

        _containerType = containerType;
        _viewWidth = viewWidth;
        _viewHeight = viewHeight;
        _scaleToStage = scaleToStage;

        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }


    /**
     * 初期化されたときに実行されるイベントです。
     * 初期化時に実行したい処理をオーバーライドして記述します。
     */
    protected function atInit():void {}


    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング前に実行したい処理をオーバーライドして記述します。
     */
    protected function atPreRender():void {}
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング前に実行したい処理をオーバーライドして記述します。
     */
    private var _onPreRender:Function = function():void{};
    public function get onPreRender():Function { return _onPreRender; }
    public function set onPreRender(value:Function):void
    {
        _onPreRender = value;
    }
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング後に実行したい処理をオーバーライドして記述します。
     */
    protected function atPostRender():void {}
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング後に実行したい処理を記述します。
     */
    private var _onPostRender:Function = function():void{};
    public function get onPostRender():Function { return _onPostRender; }
    public function set onPostRender(value:Function):void
    {
        _onPostRender = value;
    }
    
    
    /**
     * レンダリングを開始します。
     */
    public function startRendering():void
    {
        addEventListener(Event.ENTER_FRAME, onRenderTick);
    }

    /**
    * レンダリングを停止します。
    */
    public function stopRendering():void
    {
        removeEventListener(Event.ENTER_FRAME, onRenderTick);
    }

    /**
     * シングルレンダリング(レンダリングを一回だけ)を実行します。
     */
    public function singleRender():void
    {
        onRenderTick();
    }

    /**
     * @private
     */
    private function init(e:Event = null):void
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        // entry point
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.align = StageAlign.TOP_LEFT;
        stage.quality = StageQuality.HIGH;
        
        //Root objectの作成
        if (_containerType == CONFLICT) {
            container = new ConflictContainer();
        } else if (_containerType == BSP) {
            container = new BSPContainer();
        } else if (_containerType == ZSORT) {
            container = new DistanceSortContainer();
        } else if (_containerType == KD) {
            container = new KDContainer();
        } else if (_containerType == LOD) {
            container = new LODContainer();
        }
        //Viewの作成
        view = new View(stage.stageWidth, stage.stageHeight);
        view.interactive=true;
        _mc.addChild(view);

        //cameraの作成
        camera = new Camera3D();
        camera.view = view;
        camera.x = 0;
        camera.y = -500;
        camera.z = 0;
        container.addChild(camera);
        
        // Camera controller
        cameraController = new SimpleObjectController(stage, camera, 10);
        cameraController.mouseSensitivity = 0;
        cameraController.unbindAll();
        cameraController.lookAtXYZ(0, 0, 0);
        
        onResize();
        stage.addEventListener(Event.RESIZE, onResize);
        
        

        
        atInit();
    }
    
    /**
     * @private
     */    
    private function onResize(e:Event = null):void 
    {
        if (_scaleToStage)
        {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
        } 
        else
        {
            view.width = _viewWidth;
            view.height = _viewHeight;
        }
    }
    
    /**
     * @private
     */    
    private function onRenderTick(e:Event = null):void 
    {
        atPreRender();
        _onPreRender();
        cameraController.update();
        camera.render();
        atPostRender();
        _onPostRender();
    }
    
    
}

////  WONDERFL TRACE /////

import flash.display.Sprite;
import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFormat;


function inittrace(s:Stage):void
{
    WTrace.initTrace(s);
}

//global trace function
var trace:Function;

//wtreace class
class WTrace
{
        private static var FONT:String = "Fixedsys";
        private static var SIZE:Number = 12;
        private static var TextFields:Array = [];
        private static var trace_stage:Stage;
        
        public static function initTrace(stg:Stage):void
        {
            trace_stage = stg;
            trace = wtrace;
        }
        
        private static function scrollup():void
        {
            // maximum number of lines: 100
            if (TextFields.length > 100) 
            {
                var removeme:TextField = TextFields.shift();
                trace_stage.removeChild(removeme);
                removeme = null;
            }
            for(var x:Number=0;x<TextFields.length;x++)
            {
                (TextFields[x] as TextField).y -= SIZE*1.2;
            }
        }
    
        public static function wtrace(... args):void
        {
        
            var s:String="";
            var tracefield:TextField;
            
            for (var i:int;i < args.length;i++)
            {
                // imitating flash:
                // putting a space between the parameters
                if (i != 0) s+=" ";
                s+=args[i].toString();
            }
            

            tracefield= new TextField();
            tracefield.autoSize = "left";
            tracefield.text = s;
            tracefield.y = trace_stage.stageHeight - 20;

            var tf:TextFormat = new TextFormat(FONT, SIZE);
            tracefield.setTextFormat(tf);
            trace_stage.addChild(tracefield);
            scrollup();                      
            TextFields.push(tracefield);
            
        }
}

