/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y6qn
 */

// forked from eternity_hiro's BlurCircleLine
//AS3///////////////////////////////////////////////////////////////////////////
// 
// サイトの背景で使ってるもの
// http://eternitydesign.net/
// 微妙にカーソル位置使ってます。
////////////////////////////////////////////////////////////////////////////////

package {
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.display.BlendMode;
	import flash.geom.Point;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.utils.Timer;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;

	[SWF(backgroundColor="#2e3036", frameRate=30)] 


	public class ColorBlurEffect extends Sprite {
		private var container:Sprite;
		private var blur:BlurFilter;
		private var matrix:Matrix;
		private var ct:ColorTransform;
		private var ball:Sprite;
		private var bm:Bitmap;
		private var bmd:BitmapData;
		private var pos:Point;
		private var timer:Timer;
		private const ADD_CIRCLE_TIME:Number = 3000;
		private var drawTimer:Timer;
		private const DELAY:Number = 100;
		private const BALL_MAX:uint = 7;
		private const POS_RANGE:Number = 20;
		private var motionTimer:Timer;
		private const MOTION_INTERVAL:Number = 50;


		public function ColorBlurEffect() {
			container = this;

			blur = new BlurFilter(8, 8);
			matrix = new Matrix();
			ct = new ColorTransform();

			ball = new Sprite();
			ball.graphics.beginFill(0xFF0000, 0);
			ball.graphics.lineStyle(3, 0xFF000000)
			ball.graphics.drawCircle(0, 0, 10);
			ball.graphics.endFill();
			ball.filters = [blur];

			timer = new Timer(ADD_CIRCLE_TIME);
			timer.addEventListener(TimerEvent.TIMER, timerEvent);

			addEventListener(Event.ADDED_TO_STAGE, init);
		}

		private function init(e:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			pos = new Point(container.stage.stageWidth * Math.random(), container.stage.stageHeight * Math.random());

			bmd = new BitmapData(container.stage.stageWidth / 2, container.stage.stageHeight / 2, true, 0x00000000);
			bm = new Bitmap(bmd);
			bm.scaleX = 2;
			bm.scaleY = 2;
			container.addChild(bm);
			
			start();
		}

		//---------------------------------------
		// モーションの開始
		//---------------------------------------
		public function start():void {
			motionTimer = new Timer(MOTION_INTERVAL);
			motionTimer.addEventListener(TimerEvent.TIMER, motionTimerEvent);
			motionTimer.start();
			timer.start();
		}

		private function motionTimerEvent(e:TimerEvent):void {
			bmd.applyFilter(bmd, bmd.rect, new Point(), blur);
		}

		//---------------------------------------
		// 指定間隔でBitmapDataにCircleを描画する
		//---------------------------------------
		private function timerEvent(e:TimerEvent):void {
			var num:uint = BALL_MAX * Math.random() + 1;
			drawTimer = new Timer(DELAY, num);
			drawTimer.addEventListener(TimerEvent.TIMER, drawTimerEvent);
			drawTimer.addEventListener(TimerEvent.TIMER_COMPLETE, drawTimerComplete);
			drawTimer.start();
		}

		//---------------------------------------
		// 円の描画をTimerでずらす
		//---------------------------------------
		private function drawTimerEvent(e:TimerEvent):void {
			var size:Number;
			size = Math.random() * 2;
			var posX:Number = pos.x * 0.5 + (POS_RANGE * MathUtil.decimalRandomRange(-1, 1, 2));
			var posY:Number = pos.y * 0.5 + (POS_RANGE * MathUtil.decimalRandomRange(-1, 1, 2));
			matrix.identity();
			matrix.scale(size, size);
			matrix.translate(posX, posY);

			ct.color = ColorUtil.hsv2rgb(360 * Math.random(), 100, 100);

			bmd.draw(ball, matrix, ct, BlendMode.ADD);
		}

		private function drawTimerComplete(e:TimerEvent):void {
			drawTimer.removeEventListener(TimerEvent.TIMER, drawTimerEvent);
			drawTimer.removeEventListener(TimerEvent.TIMER_COMPLETE, drawTimerComplete);
			drawTimer = null;

			pos.x = container.mouseX;
			pos.y = container.mouseY;
		}
	}
}

class ColorUtil {
	//--------------------------------------------------
	//  HSVをRGBに変換
	//  h : 0 - 360
	//  s,v : 0 - 100
	//--------------------------------------------------
	public static function hsv2rgb(h:Number, s:Number, v:Number):uint {
		var r:Number;
		var g:Number;
		var b:Number;

		h = (h < 0) ? h % 360 + 360 : (h >= 360) ? h % 360 : h;
		s = (s < 0) ? 0 : (s > 100) ? 100 : s;
		v = (v < 0) ? 0 : (v > 100) ? 100 : v;

		s *= 0.01;
		v *= 0.01;

		if(s == 0) {
			var val:Number = v * 255;
			trace("val : " + val);
			r = g = b = Math.round(val);
		}
		else {
			var hi:Number = Math.floor(h / 60) % 6;
			var f:Number = h / 60 - hi;
			var p:Number = v * (1 - s);
			var q:Number = v * (1 - s * f);
			var t:Number = v * (1 - (s * (1 - f)));

			switch(hi) {
				case 0:
					r = v;
					g = t;
					b = p;
					break;

				case 1:
					r = q;
					g = v;
					b = p;
					break;

				case 2:
					r = p;
					g = v;
					b = t;
					break;

				case 3:
					r = p;
					g = q;
					b = v;
					break;

				case 4:
					r = t;
					g = p;
					b = v;
					break;

				case 5:
					r = v;
					g = p;
					b = q;
					break;
			}

			r = Math.round(r * 255);
			g = Math.round(g * 255);
			b = Math.round(b * 255);
		}

		return getUintRGB(r, g, b);
	}

	public static function hsva2argb(h:Number, s:Number, v:Number, a:Number):uint {
		return (((a * 2.55) << 24) | hsv2rgb(h, s, v));
	}
		
	private static function getUintRGB(r:int, g:int, b:int):uint {
		return ((r & 0xff) << 16) | ((g & 0xff) << 8) | (b & 0xff);
	}
}

class MathUtil {
	public static function decimalRandomRange(min:Number, max:Number, digit:uint = 0):Number {
		var randomNum:Number = Math.random() * (max - min) + min;
		return decimalRound(randomNum, digit);
	}
	
	public static function decimalRound(i:Number , digit:uint):Number {
		return Math.round(i * Math.pow(10 , digit)) / Math.pow(10 , digit);
	}
}
