/**
 * Copyright Nicolas ( http://wonderfl.net/user/Nicolas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y6ET
 */

// forked from shapevent's Black and White Circles

//目にうるさいのができあがった
package {

	import flash.display.*;
	import flash.geom.*;
	import flash.events.*;


	[SWF(backgroundColor=0xFFFFFF, width=500, height=500)]

       public class ColorfulCirc extends MovieClip {
		private var hsw:Number;
		private var hsh:Number;
		private var pointNum:int;
		private var points3D:Vector.<Number>;
		private var points2D:Vector.<Number>;
		private var uvts:Vector.<Number>;
		private var sorted:Array;
		private var thickness:Vector.<Number>;
		private var radii:Vector.<Number>;
		private var colors:Vector.<uint>;
		private var pnt:Point;
		private var m:Matrix3D;
		private var v:Vector3D;
		private var p:PerspectiveProjection;
		private var proj:Matrix3D;
		private var dx:Number;
		private var dy:Number;
                  private var colorList:Vector.<uint>;

               public function ColorfulCirc(){
                  // init
			
			hsw = stage.stageWidth / 2;
			hsh = stage.stageHeight / 2;
			pointNum = 150;
			points3D = new Vector.<Number>();
			points2D = new Vector.<Number>();
			uvts = new Vector.<Number>();
			sorted = [];
			thickness = new Vector.<Number>();
			radii = new Vector.<Number>();
			colors = new Vector.<uint>();
			colorList = new Vector.<uint>();
			colorList.push(0x3333FF, 0xFFFF33, 0xFF3333, 0x33FF33, 0x33FFFF, 0xFF33FF);
			pnt = new Point();
			m = new Matrix3D();
			v = new Vector3D();
			
			for (var i:int = 0; i<pointNum; i++){
				v.x = Math.random()*1000-500;
				m.identity();
				m.appendRotation(Math.random()*360, Vector3D.X_AXIS);
				m.appendRotation(Math.random()*360, Vector3D.Y_AXIS);
				m.appendRotation(Math.random()*360, Vector3D.Z_AXIS);
				v = m.transformVector(v);
				points3D.push(v.x, v.y, v.z);
				points2D.push(0,0);
				uvts.push(0,0,0);
				sorted.push({});
				thickness.push(Math.random() * Math.random() * 50 + 4);
				radii.push(Math.random() * 100 + 10);
				colors.push(colorList[int(Math.random()*colorList.length)]);
			}
			points3D.fixed = true;
			points2D.fixed = true;
			uvts.fixed = true;
			thickness.fixed = true;
			radii.fixed = true;
			colors.fixed = true;x
			p = new PerspectiveProjection();
			proj = p.toMatrix3D();
			dx = 0, dy = 0;
			addEventListener(Event.ENTER_FRAME, onLoop);
			

               }
               // private methods

		private function onLoop(evt:Event):void {
			var i:int, j:int;
			dx += (mouseX - dx) / 4;
			dy += (mouseY - dy) / 4;
			m.identity();
			m.appendRotation(dx, Vector3D.Y_AXIS);
			m.appendRotation(dy, Vector3D.X_AXIS);
			m.appendTranslation(0, 0, 1000);
			m.append(proj);
			Utils3D.projectVectors(m, points3D, points2D, uvts);
			for (i = 0, j = 0; i<points2D.length; i+=2, j++){
				sorted[j].x = points2D[i] + hsw;
				sorted[j].y = points2D[i + 1] + hsh;
				sorted[j].z = uvts[j * 3 + 2];
				sorted[j].color = colors[j];
				sorted[j].radius = radii[j];
				sorted[j].thickness = thickness[j];
			}
			sorted.sortOn("z", Array.NUMERIC);
			graphics.clear();
			for(i = 0; i<sorted.length; i++){
				var element:Object = sorted[i];
				var zpos:Number = element.z * 18000;
				graphics.lineStyle(element.thickness, element.color);
				graphics.drawCircle(element.x, element.y, zpos + element.radius);
				graphics.endFill();
			}
		}
		

       }

}