/**
 * Copyright t2421 ( http://wonderfl.net/user/t2421 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y5hu
 */

package {
    import flash.system.Security;
    import flash.ui.Mouse;
    import flash.events.MouseEvent;
    import flash.display.MovieClip;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.net.URLRequest;
    import flash.display.LoaderInfo;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var particle:Particle;

        private var particle_arr:Vector.<Particle>;

        private var numParticle:uint = 20000;



        private var isDown:Boolean = false;

        private var defForceParam:Number = 10000;

        private var forceParam:Number;

        private var friction:Number = 0.96;
        

        private var bitmap:Bitmap;

        private var bitmapdata:BitmapData;

        private var density:uint = 1;

        

        private var bg:Bitmap;

        private var bgd:BitmapData;

        

        private var offsetX:Number = 0;

        private var offsetY:Number = 0;

        

        private var random1:Vector.<Number>;

        private var random2:Vector.<Number>;

        private var count:uint = 0;

        private var mouseDummy:Particle;
        private var _loader:Loader;
       private var textObj:MovieClip;

        private var _loaderInfo:LoaderInfo;
        public function FlashTest() {
           
            Security.loadPolicyFile( "http://t2421.jp/wonderfl/crossdomain.xml"); 
            _loader = new Loader( ) ;
            var urlReq :URLRequest = new URLRequest("http://t2421.jp/wonderfl/osewa.gif");
            _loader.load( urlReq );
            _loaderInfo = _loader.contentLoaderInfo ;
            _loaderInfo.addEventListener( Event.COMPLETE, readcomp);
        }
        
        private function readcomp(e:Event):void{
          
             textObj= new MovieClip();
            textObj.addChild(_loader);
            initialize();
        }
        
        private function initialize():void 

        {

          



            

            random1 = new Vector.<Number>;

            random2 = new Vector.<Number>;

            for (var i:int = 0; i < 1100; i++) 

            {

                random1.push(Math.random() * (_loader.x + _loader.width));

                random2.push(Math.random() * (_loader.y + _loader.height));

            }

            mouseDummy = new Particle();

            mouseDummy.y = stage.stageHeight / 2;

            offsetX = _loader.x;

            offsetY = _loader.y;

            forceParam = defForceParam;

            bitmapdata = new BitmapData(stage.stageWidth, stage.stageHeight, true,0xffffffff);

            bitmap = new Bitmap(bitmapdata);

            bitmapdata.draw(_loader);

            addChild(bitmap);

        

            particle_arr = new Vector.<Particle>;

            /*for (var i:int = 0; i < numParticle; i++) 

            {

                var particle = new Particle();

                particle.x =particle.homeX= 200*Math.random()+100;

                particle.y =particle.homeY= 200*Math.random()+100;

                particle_arr.push(particle);



            }*/

            bitmapAnalys();

            _loader.visible = false;    

            

            this.addEventListener(Event.ENTER_FRAME, loop);

            stage.addEventListener(MouseEvent.MOUSE_DOWN, downhandler);

            stage.addEventListener(MouseEvent.MOUSE_UP, uphandler);

        }

        

        private function uphandler(e:MouseEvent):void 

        {

            isDown = false;

            //ax2 = -0.5;

        }

        

        private function downhandler(e:MouseEvent):void 

        {

            trace("down");

            isDown = true;

        }

        



        

        private function loop(e:Event):void 

        {

            

            setRandom();

            calcVelocity();

            

            draw();

        }

        

        private function setRandom():void {

            

            if (count < 1000) {

                count++;

            }else {

                count = 0;

            }

            mouseDummy.x = random1[count];

            mouseDummy.y = random2[count];

        }

        

        private function draw():void 

        {

            bitmapdata.lock();

            bitmapdata.fillRect(bitmap.getRect(this), 0xffffffff);

            var len:uint = particle_arr.length;

            for (var i:int = 0; i < len; i++) 

            {

                bitmapdata.setPixel(particle_arr[i].x,particle_arr[i].y,particle_arr[i].color);

                

            }

            bitmapdata.unlock();

            

        }

        

        private function calcVelocity():void 

        {

            if (isDown) {

                forceParam = 30000;

            }else {

                forceParam = defForceParam;

            }

            var len:uint = particle_arr.length;



            for (var i:int = 0; i < len; i++) {

                var particle:Particle = particle_arr[i];

                var homeDX:Number = particle.homeX - particle.x;

                var homeDY:Number = particle.homeY - particle.y;

                var homeDistance:Number = Math.sqrt((homeDX * homeDX) + (homeDY * homeDY));

                var homeForce:Number = homeDistance * 0.01;

                var homeAngle:Number = Math.atan2(homeDY, homeDX);

                var cursorForce:Number = 0;

                var cursorAngle:Number = 0;

                

                if (mouseDummy.x > 0) {

                    var cursorDX:Number = particle.x - mouseDummy.x;

                    var cursorDY:Number = particle.y - mouseDummy.y;

                    var cursorDistanceSquared:Number = Math.pow(cursorDX, 2) + Math.pow(cursorDY, 2);

                    cursorForce = Math.min(forceParam / cursorDistanceSquared, forceParam);

                    cursorAngle=Math.atan2(cursorDY,cursorDX);

                }else{
                    cursorForce=0;

                    cursorAngle=0;

                  }

                  particle.vx += homeForce * Math.cos(homeAngle) + cursorForce * Math.cos(cursorAngle);

                  particle.vy += homeForce * Math.sin(homeAngle) + cursorForce * Math.sin(cursorAngle);

                  particle.vx *= friction;

                  particle.vy *= friction;

                  //particle.color = cursorForce*0x00ff00;

                  particle.x += particle.vx;

                particle.y += particle.vy;

            }

            

        

              

        }

        



        private function bitmapAnalys():void 

        {

            

            for (var i:int = 0; i < bitmapdata.width; i+=density) 

            {

                for (var j:int = 0; j < bitmapdata.height; j+=density) 

                {

                    var color:uint = bitmapdata.getPixel(i, j);

                    if (color != 0xFFFFFF) {

                       

                        var particle:Particle = new Particle();

                        particle.x =particle.homeX= i+offsetX;

                        particle.y =particle.homeY= j+offsetY;

                        particle.color = color;

                        particle_arr.push(particle);

                       

                    }    

                }

            }

            

        }

    }
}




import flash.display.Bitmap;

    import flash.display.BitmapData;

    import flash.display.DisplayObject;

    import flash.display.DisplayObjectContainer;

    import flash.display.Sprite;

    /**

     * ...

     * @author taiga

     */

    class Particle

    {



        public var color:uint = 0x000000;

        public var random:Number;

        public var x:Number = 0;

        public var y:Number = 0;

        public var vx:Number = 0;

        public var vy:Number = 0;

        public var homeX:Number = 0;

        public var homeY:Number = 0;

        

        public function Particle() 

        {

            random = Math.random();

        }

        

        

        

    }