/**
 * Copyright alpicola ( http://wonderfl.net/user/alpicola )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y4Xt
 */

package {
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.utils.ByteArray;
	import flash.utils.Timer;
	import com.adobe.images.JPGEncoder;

	[SWF(backgroundColor="#000", frameRate="10")] 
	
	public class Glitch extends Sprite {
		
		private var camera:Camera;
		private var video:Video;
		private var bitmap:BitmapData;
		private var bytes:ByteArray;
		private var display:Loader;
		private var encoder:JPGEncoder;
		private var header:int;
		
		public function Glitch() {
			stage.align = "TL";
			stage.scaleMode = "noScale";

			camera = Camera.getCamera();
			if (camera == null) return;
			camera.setMode(stage.stageWidth, stage.stageHeight, 1);
			video = new Video(camera.width, camera.height);
			video.attachCamera(camera);
			bitmap = new BitmapData(camera.width, camera.height, false);
			encoder = new JPGEncoder();
			display = new Loader();
			addChild(display);

			capture(null);
			
			var timer:Timer = new Timer(1000);
			timer.addEventListener(TimerEvent.TIMER, capture);
			timer.start();
			addEventListener(Event.ENTER_FRAME, update);
		}

		private function capture(e:TimerEvent):void {
			bitmap.draw(video);
			bytes = encoder.encode(bitmap);
			header = 0;
			for (var length:int = bytes.length; header < length; header++) {
				if (bytes[header] == 0xff && bytes[header+1] == 0xda) {
				   header += 6;
				   break;
			   }
			}
		}

		private function update(e:Event):void {
			bytes.position = Math.floor((bytes.length - header) * Math.random()) + header;
			bytes.writeByte(0);
			display.loadBytes(bytes);
		}

	}
}
