/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y4Mk
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    
    [SWF(frameRate = 60, width = 460, height = 345)]
    public class Ray extends Sprite
    {
        internal var _start :Point = new Point(30, 22.5);
        internal var _end   :Point = new Point(400, 300);
        
        internal var sprite1 :Sprite = new Sprite();
        internal var sprite2 :Sprite = new Sprite();
        internal var sprite3 :Sprite = new Sprite();
        
        public function Ray()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            
            sprite1.graphics.beginFill     (0, 0.5);
            sprite1.graphics.drawRect      (0, 0, 50, 50);
            sprite1.graphics.endFill       ();
            
            sprite2.graphics.beginFill     (0, 0.5);
            sprite2.graphics.drawCircle    (0, 0, 30);
            sprite2.graphics.endFill       ();
            
            sprite3.graphics.beginFill     (0, 0.5);
            sprite3.graphics.drawRoundRect (0, 0, 55, 55, 24);
            sprite3.graphics.endFill       (); 
            
            _init();
        }
        
        public function _init() :void
        {
            addChild(sprite1);
            addChild(sprite2);
            addChild(sprite3);
        }

        public function lineMechanics($start:Point, $end:Point) :Array
        {
            graphics.clear();
            graphics.lineStyle(3, 0);
            graphics.moveTo($start.x, $start.y);
            graphics.lineTo($end.x, $end.y);
        
            for (var $x :Number = $start.x; $x < $end.x; $x++)
            {
                for (var $y :Number = $start.y; $y < $end.y; $y++)
                {
                    if (sprite1.hitTestPoint($x, $y, true)) { graphics.clear(); graphics.lineStyle(3, 0xFF0000); graphics.moveTo($start.x, $start.y); graphics.lineTo($end.x, $end.y);}
                }
            }
            
            return null;
        }
        
        internal var firstPoint :Point = new Point();
        internal var currentPoint :Point = new Point();
        internal var calcPoint :Point = new Point();
        
        internal var mouseObj :Object;
        
        public function onMouseDown($e:MouseEvent) :void
        {
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            
            firstPoint = new Point($e.stageX, $e.stageY);
            
            mouseObj = $e.target;
        }
        
        public function onMouseMove($e:MouseEvent) :void
        {
            if (mouseObj != stage)
            {
                currentPoint = new Point($e.stageX, $e.stageY);
                calcPoint = Point(currentPoint.subtract(firstPoint));
                
                mouseObj.x = mouseObj.x + calcPoint.x;
                mouseObj.y = mouseObj.y + calcPoint.y;
                
                firstPoint = currentPoint;
            }
        }
        
        public function onMouseUp($e:MouseEvent) :void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            
            lineMechanics(_start, _end);
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.net.*;


class Vector2D
{
    private var _x:Number;
    private var _y:Number;
        
    public function Vector2D(x:Number = 0, y:Number = 0)
    {
        _x = x;
        _y = y;
    }

    public function cloneVector() :Vector2D
    { return new Vector2D(x, y); }

    public function zeroVector() :Vector2D 
    {
        _x = 0;
        _y = 0;
        return this;
    }
    
    public function isZero() :Boolean
    { return _x == 0 && _y == 0; }
        
    public function isNormalized() :Boolean
    { return length == 1.0; }
         
    public function equals(vector2:Vector2D) :Boolean 
    { return _x == vector2.x && _y == vector2.y; }
        
    public function get length() :Number
    { return Math.sqrt(lengthSquared); }
        
    public function get lengthSquared() :Number
    { return _x * _x + _y * _y; } //perform sqrt extraneously, faster performance
        
    public function get angle() :Number
    { return Math.atan2(_y, _x); }

    public function set length(value:Number) :void
    {
        var _angle:Number = angle;
        
        _x = Math.cos(_angle) * value;
        _y = Math.sin(_angle) * value;
        
        if(Math.abs(_x) < 0.00000001) _x = 0;
        if(Math.abs(_y) < 0.00000001) _y = 0;
    }

    public function set angle(value:Number) :void
    {
        var len:Number = length;
        
        _x = Math.cos(value) * len;
        _y = Math.sin(value) * len;
    }

    public function normalize() :Vector2D
    {
        var len:Number = length;
        
        if(length == 0)
        { _x = 1; return this; }
            
        _x /= len;
        _y /= len;
        
        return this;
    }
        
    public function normalcate(len:Number) :Vector2D
    { length = len; return this; }
        
    public function truncate(max:Number) :Vector2D
    { length = Math.min(max, length); return this; }
        
    public function reverse() :Vector2D
    { _x = -_x; _y = -_y; return this; }
        
    public function dotProduct(vector2:Vector2D) :Number
    { return ((_x * vector2.x) + (_y * vector2.y)); }
        
    public function crossProd(vector2:Vector2D) :Number
    { return ((_x * vector2.y) - (_y * vector2.x)); }
        
    public static function angleBetween(vector1:Vector2D, vector2:Vector2D) :Number 
    {
        if(!vector1.isNormalized()) vector1 = vector1.cloneVector().normalize();
        if(!vector2.isNormalized()) vector2 = vector2.cloneVector().normalize();
        
        return Math.acos(vector1.dotProduct(vector2));
    }

    public function sign(vector2:Vector2D) :int
    { return perpendicular.dotProduct(vector2) < 0 ? -1 : 1; }
        
    public function get perpendicular() :Vector2D
    { return new Vector2D(-y, x); }
        
    public function distance(vector2:Vector2D) :Number
    { return Math.sqrt(distSQ(vector2)); }
        
    public function distSQ(vector2:Vector2D) :Number
    {
        var dx:Number = vector2.x - x;
        var dy:Number = vector2.y - y;
        
        return dx * dx + dy * dy;
    }
        
    public function add(vector2:Vector2D) :Vector2D
    { _x += vector2.x; _y += vector2.y; return this; }
        
    public function subtract(vector2:Vector2D) :Vector2D 
    { _x -= vector2.x; _y -= vector2.y; return this; }

    public function multiply(scalar:Number) :Vector2D
    { _x *= scalar;  _y *= scalar; return this; }
        
    public function divide(scalar:Number) :Vector2D
    { _x /= scalar; _y /= scalar; return this; }

    public function set y(value:Number) :void
    { _y = value; }
    
    public function get y() :Number
    { return _y; }
        
    public function set x(value:Number) :void
    { _x = value; }
        
    public function get x() :Number
    { return _x; }
        
    public function fromString(string:String) :Vector2D
    {
        var vector:Vector2D = new Vector2D();
        var tx:Number;
        var ty:Number;
            
        tx = int(string.substr(string.indexOf("x:"),string.indexOf(",")));
        ty = int(string.substr(string.indexOf("y:")));
            
        vector.x = tx;
        vector.y = ty;
            
        return vector;
    }
        
    public function toString():String
    { return "Vector2D x:" + _x + ", y:" + _y; }
        
    public function drawVector(graphicsForDrawing:Graphics, drawingColor:uint = 0x00FF00) :void
    {
        graphicsForDrawing.lineStyle(0, drawingColor);
        graphicsForDrawing.moveTo(0, 0);
        graphicsForDrawing.lineTo(_x, _y);
    }
}