/**
 * Copyright yun ( http://wonderfl.net/user/yun )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y1sV
 */

// forked from yun's カメラの動きを指定
// forked from yun's 3Dオブジェクトに動きを付ける
// forked from yun's シンプルな3Dオブジェクト
package {
    import flash.events.Event;
    import flash.events.WeakFunctionClosure;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    
    public class Sample extends BasicView {
        private var sphere1:Sphere;
        private var sphere2:Sphere;
        public function Sample():void {
            // マテリアルを作成
            var material:WireframeMaterial = new WireframeMaterial( 0xFF0000 );
            
            // 3Dオブジェクトを作成
            sphere1 = new Sphere( material, 300, 10, 10 );
            sphere2 = new Sphere( material, 300, 10, 10 );
            
            // 座標を設定
            sphere1.x = 500;
            sphere2.x = -500;
            
            // 3Dシーンに追加して表示
            scene.addChild( sphere1 );
            scene.addChild( sphere2 );
            
            // レンダリングを開始
            startRendering();
            
            // エンターフレームを設定
            addEventListener( Event.ENTER_FRAME, loop );
        }
        
        private function loop( e:Event ):void {
            // 球面をY軸方向に回転
            sphere1.rotationY += 1;
            sphere2.rotationX += 1;
            
            // カメラの位置を変更
            var rateX:Number = mouseX / stage.stageWidth;
            var targetX:Number = -5000 * ( rateX - 0.5 );
            camera.x += ( targetX - camera.x ) * 0.2;
            
            var rateY:Number = mouseY / stage.stageHeight;
            var targetY:Number = 5000 * ( rateY - 0.5 );
            camera.y += ( targetY - camera.y ) * 0.2;
        }
    }
}