/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/y1is
 */

// forked from clockmaker's [PV3D]BitmapFileMaterialを利用した場合のクロスドメイン対処方法
// forked from a24's forked from: [PV3D]外部画像をLoaderを利用して読み込んだ場合の実装方法
// forked from clockmaker's [PV3D]外部画像をLoaderを利用して読み込んだ場合の実装方法
package {
    import flash.system.*;
    import flash.utils.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.view.*;
    
    /**
    * 外部画像をBitmapFileMaterialを使って読み込むデモ
    */
    public class Main extends BasicView {
        public function Main():void {
            opaqueBackground = 0x0; // 背景を黒くする
            stage.quality = "low"; // שלא יאכל יותר מדי CPU
            
            // クロスドメイン対策
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
            
            // 画像ファイルのパス
            const url:String = "http://assets.wonderfl.net/images/related_images/7/7a/7a1e/7a1e6ef276b0d7da95e79499fbfae10ceee8e9b6";
            
            // マテリアル(テクスチャ)をBitmapFileMaterialとして作成
            var material:BitmapFileMaterial = new BitmapFileMaterial(url, true);
            material.doubleSided = true; // 両面にテクスチャを貼る
            
            // 平面を作成
            var cnt:uint = 6;
            var rot:Number = 0;
            var tree:DisplayObject3D = new DisplayObject3D;
            for( var i:uint = 0; i < cnt; i++ ) {
                var plane:Plane = new Plane(material, 1200, 1200);
                plane.rotationY = rot;
                tree.addChild( plane );
                rot += 180 / cnt;
            }
            
            scene.addChild( tree );
            
           
            // レンダリング開始
            startRendering();
            
            // ついでに回転でもさせておく
            addEventListener("enterFrame", function():void {
                tree.rotationY++;
                camera.y = Math.sin(getTimer()/4000) * 400;
            });
        }
    }
}