/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xzhy
 */

package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.Event;
    public class FlashTest extends Sprite {
		private var _array:/*uint*/Array;
		private var _i:int;
		private var _j:int;
		
		private const NUM:uint = 150;
		
        public function FlashTest() {
			_i = NUM - 2;
			_j = 0;
			
			var a:Array = new Array();
			for (var index:uint = 0; index < NUM; ++index) {
				a.push(index + 1);
			}
			_array = new Array();
			while (a.length > 0) {
				var i:uint = a.length * Math.random();
				_array.push(a[i]);
				a.splice(i, 1);
			}

			draw();
			
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function proc(e:Event):void {
			for (var i:uint = 0; i < 50; ++i) {
				update();
			}
			
			draw();
		}
		
		private function update():void {
			if (_j > NUM - 2) return;
			
			if (_array[_i] > _array[_i + 1]) {
				var tmp:uint = _array[_i];
				_array[_i] = _array[_i + 1];
				_array[_i + 1] = tmp;
			}
			
			--_i;
			if (_i < _j) {
				++_j;
				_i = NUM - 2;
			}
			
			draw();			
		}
		
		private function draw():void {
			var gfx:Graphics = this.graphics;
			gfx.clear();
			
			gfx.beginFill(0x404040);
			gfx.drawRect(0, 0, 465, 465);
			gfx.endFill();

			for (var index:uint = 0; index < NUM; ++index) {
				var value:uint = _array[index] * 3;

				var r:uint = 255;
				var g:uint = 100 + _array[index];
				var b:uint = g;
				var color:uint = (r << 16) + (g << 8) + (b << 0);

				gfx.beginFill(color);
				gfx.drawRect(7.5 + (index * 3), 7.5 + (450 - value), 2, value);
				gfx.endFill();
			}
		
		}
    }
}