/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xzLy
 */

// forked from nicoptere's flash on 2010-1-27
package {
	import flash.utils.ByteArray;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    public class FlashTest extends Sprite {
        public function FlashTest()
        {
            addChild( new Bitmap( getColorMap(512,512)) );
            
        }
         
         public function getColorMap( width:int = 256, height:int = 256 ):BitmapData
        {
            var ba:ByteArray = new ByteArray();
            var i:int = width * height * 4;
            while( i > 0 )
            {
              var hue:Number = ( ( (i >> 2) % width ) / ( width - 1 ) ) * 2 * Math.PI;
            	  var brightness:Number = ( (i >> 2) / width ) / ( height - 1 );            
            	  ba[--i] = brightness * 127.5 * (Math.cos( hue + Math.PI * 2 / 3 ) + 1 );
			  ba[--i] = brightness * 127.5 * (Math.cos( hue + Math.PI * 4 / 3 ) + 1 );
            	  ba[--i] = brightness * 127.5 * (Math.cos( hue ) + 1 );
            	  ba[--i] = 0xff;
            	}
            
            var bm:BitmapData = new BitmapData( width, height );
            bm.setPixels( bm.rect, ba );            
            return bm;
        }
        
        
    }
}