/**
 * Copyright Dorara ( http://wonderfl.net/user/Dorara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xyRG
 */

// Seven Puzzle
// ただ遊びたかっただけ。
// 完成形-------
//     1  2  3
//  4  5  6  7
//  ------------  
package {
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;

	[SWF(backgroundColor=0x000000)]
	public class sevenpuzzle extends Sprite
	{
		private var Field:Array;
		private var Fieldobj:Array;
		private var Fieldtext:Array;
		public function sevenpuzzle()
		{
			this.stage.scaleMode = StageScaleMode.NO_SCALE;
			this.stage.align = StageAlign.TOP_LEFT;
			
			Field = new Array(4);
			Fieldobj = new Array(4);
			Fieldtext = new Array(4);
			for(var i:int = 0; i < 4; i++)
			{
				var tmp:Array = new Array(6);
				var ttmp:Array = new Array(6);
				var tttmp:Array = new Array(6);
				Field[i] = tmp;
				Fieldobj[i] = ttmp;
				Fieldtext[i] = tttmp;
				for(var j:int = 0; j < 6; j++)
				{
					Field[i][j] = 9;
					
					var t:Sprite = new Sprite();
					t.graphics.beginFill(0xffffff);
					t.graphics.drawRect(0, 0, 50, 50);
					t.graphics.endFill();
					t.addEventListener(MouseEvent.CLICK, clicked);
					t.x = j * 51;
					t.y = i * 51;
					this.addChild(t);
					Fieldobj[i][j] = t;
					
					var text:TextField = new TextField();
					text.text = "";
					text.x = j * 51;
					text.y = i * 51;
					text.width = 12;
					text.height = 30;
					text.selectable = false;
					text.addEventListener(MouseEvent.CLICK, clicked);
					this.addChild(text);
					Fieldtext[i][j] = text;
				}
			}
			
			initField();
			showField();
		}
		
		//初期化
		public function initField():void
		{
			//初期配置はいろいろ、ちょっとむずかしめ(最短手順:1,10,15,22,34,36)
			var tmp:Array = new Array(10234567,24031567,16302547,15037426,45271063,32547610);
			var r:int = tmp[(int)(Math.random()*5)];
			for(var i:int = 2; i >= 1; i--)
			{
				for(var j:int = 4; j >= 1; j--)
				{
					Field[i][j] = r%10;
					r = r/10;
				}
			}
		}

		//無駄に毎回全部表示を直す
		public function showField():void
		{
			for(var i:int = 0; i < 4; i++)
			{
				for(var j:int = 0; j < 6; j++)
				{
					if(0<Field[i][j] && Field[i][j]<9)
					{
						Fieldtext[i][j].text = (Field[i][j]).toString();
					}
					if(Field[i][j] == 9 || Field[i][j] == 0) Fieldobj[i][j].graphics.beginFill(0x000000);
					else Fieldobj[i][j].graphics.beginFill(0xffffff);
					Fieldobj[i][j].graphics.drawRect(0, 0, 50, 50);
					Fieldobj[i][j].graphics.endFill();
					Fieldobj[i][j].x = j * 51;
					Fieldobj[i][j].y = i * 51;
				}
			}
		}

		//クリック時に、隣に0があれば、それとプレゼント交換
		public function clicked(e:Event):void
		{
			var _x:int = e.target.x/51;
			var _y:int = e.target.y/51;
			if(0<_x && _x <5 && 0<_y && _y<5)
			{
				if(0<Field[_y][_x] && Field[_y][_x]<9)
				{
					if(Field[_y-1][_x] == 0){ //上と交換
						swap(_x,_y,_x,_y-1);
					}
					else if(Field[_y][_x+1] == 0){ //右と交換
						swap(_x,_y,_x+1,_y);
					}
					else if(Field[_y+1][_x] == 0){ //下と交換
						swap(_x,_y,_x,_y+1);
					}
					else if(Field[_y][_x-1] == 0){ //左と交換
						swap(_x,_y,_x-1,_y);
					}
					else{ //交換しない
						return;
					}
					showField();
					//クリアしてたら、なんと！
					if(isClear())
					{
						//もう一回
						initField();
						showField();
					}
				}
			}
		}
		
		//交換
		public function swap(x:int, y:int, tx:int, ty:int):void
		{
			var tmp:int = Field[y][x];
			Field[y][x] = Field[ty][tx];
			Field[ty][tx] = tmp;
		}
		
		//クリアかどうか
		public function isClear():Boolean
		{
			var t:int = 0;
			for(var i:int = 1; i <= 2; i++)
			{
				for(var j:int = 1; j <= 4; j++)
				{
					t = t*10 + Field[i][j];
				}
			}
			if(t==1234567) return true;
			return false;
		}
	}
}