/**
 * Copyright inippo ( http://wonderfl.net/user/inippo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xyOU
 */

/*
カメラを繰り返し描画して動いた箇所（差分のある箇所）を描画します。
前回の毎回更新されるバージョンに手を加えて、古い描画を残したまま上塗りします。

--前回の描画はこちら--
http://wonderfl.net/c/iOQW

*/
package{
    
        import flash.display.*;
        import flash.events.*;
        import flash.geom.*;
        import flash.media.*;
        import flash.system.*;
        import flash.text.*;
        import flash.utils.*;
        
        public class PhysicalBitmap2 extends MovieClip{
        public var camera:Camera;        
        public var video:Video;        
        public var copyBmd:BitmapData;        
        public var canvasBmd:BitmapData;
        public var canvas:Bitmap;
        
        public var prevAry:Array = [];
        
        public const DIFF_NUM:Number = 5000000; // 差分のしきい値
        public const CANVAS_COLOR:uint = 0xFFFFFF; // キャンバスの色
        
        
        public function PhysicalBitmap2(){
            
            // カメラを検出
            camera = Camera.getCamera();
            if (camera != null){
                if (camera.muted) {
                    // 許可されない
                    trace("許可されない");
                    Security.showSettings(SecurityPanel.PRIVACY);
                    camera.addEventListener(StatusEvent.STATUS, statusHandler);
                }else {
                    // 許可
                    trace("許可");
                    connectCamera();
                }
            }
        }
        
        public function statusHandler(event:StatusEvent):void{
            if(event.code == "Camera.Unmuted"){
                connectCamera();
                camera.removeEventListener(StatusEvent.STATUS, statusHandler);
            }
        }
        
        
        /**
         * 描画の準備
         */
        public function connectCamera():void {
            
            // ビデオの生成（カメラの映像を投影する）
            video = new Video();
            video.attachCamera(camera);
            
            // 映像を複製するビットマップデータを作成
            copyBmd = new BitmapData (video.width, video.height);
            
            // 表示用のキャンバスを作成
            canvasBmd = new BitmapData (video.width, video.height);
            canvas = new Bitmap(canvasBmd);
            canvas.x = stage.stageWidth/2 - video.width/2;
            canvas.y = stage.stageHeight / 2 - video.height / 2;
            
            addChild(canvas);
            
            
            /*
             ここから初回の描画
            */
            copyBmd.lock();
            copyBmd.draw (video);
            
            // 1ピクセルずつ描画
            for (var xx:int; xx < video.width; xx++)
            {
                for (var yy:int; yy < video.height; yy++)
                {
                    var col:uint = copyBmd.getPixel(xx, yy);
                    prevAry.push(col);
                }
                
                yy = 0;
                
            }
            
            copyBmd.unlock();
            
            // タイマーで描画の繰り返し
            var timer:Timer = new Timer(33);
            timer.addEventListener(TimerEvent.TIMER, loop);
            timer.start();
            
        }
        
        
        /**
         * カメラの映像を繰り返しビダミービットマップに描画する。
         * 差分だけをさらに検出して描画。
         */
        public function loop(event:TimerEvent):void{
            
            var i:int;
            
            copyBmd.lock();
            canvasBmd.lock();
            
            // ビデオの映像を描画する
            copyBmd.draw(video);
            
            // 1ピクセルずつ描画
            for (var xx:int; xx < video.width; xx++)
            {
                for (var yy:int; yy < video.height; yy++)
                {
                    var col:uint = copyBmd.getPixel(xx, yy);
                    
                    /*
                     差分がしきい値を超えていいる場合は描画を更新。
                     古い描画はそのまま残す。
                    */
                    if (Math.abs(prevAry[i] - col) > DIFF_NUM)
                    {
                        canvasBmd.setPixel(xx, yy, col);
                    }
                    
                    prevAry[i] = col;
                    i++;
                    
                }
                
                yy = 0;
                
            }
            
            copyBmd.unlock();
            canvasBmd.unlock();
            
        }


    }
}
