/**
 * Copyright shapevent ( http://wonderfl.net/user/shapevent )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xyHJ
 */

// forked from shapevent's flash on 2009-8-7
package {
  
        // this renders the implicit equation for a torus:
        // Math.pow(vx  * vx  + vy * vy + vz * vz + R*R - r * r, 2) - 4 * (R * R)*(vx * vx + vy * vy);
        
        // more info here: http://actionsnippet.com/?p=1343

	import flash.display.*;
	import flash.geom.*;


	[SWF(backgroundColor = 0x000000)]

       public class DistanceRender extends MovieClip {
		private var verts:Vector.<Number>;
		private var pVerts:Vector.<Number>;
		private var uvts:Vector.<Number>;
		private var hs:Number;
		private var step:Number;
		private var tVerts:Vector.<Number>;
		private var rVerts:Vector.<Number>;
		private var matrix:Matrix3D;
		private var inc:int;
		private var i:Number;
		private var j:Number;
		private var k:Number;
		private var vinc:int;
		private var R:Number;
		private var r:Number;
		private var canvas:BitmapData;


               public function DistanceRender(){
                  // init
			verts = new Vector.<Number>();
			pVerts = new Vector.<Number>();
			uvts = new Vector.<Number>();
			hs = 2.3;
			step = 0.04;
			tVerts = new Vector.<Number>();
			rVerts = new Vector.<Number>();
			matrix = new Matrix3D();
			matrix.identity();
			matrix.appendRotation(45,Vector3D.Y_AXIS);
			matrix.appendRotation(45,Vector3D.X_AXIS);
			inc = 0;
			i, j, k;
			i = hs;
			while( i> -hs){
				j = hs;
				while(j> -hs){
					k = hs;
					while(k> -hs){
						tVerts[inc] = -i;
						inc++
						tVerts[inc] = -j;
						inc++
						tVerts[inc] = -k;
						inc++
						k -= step;
					}
					j -= step;
				}
				i -= step;
			}
			matrix.transformVectors(tVerts, rVerts);
			vinc = 0;
			inc = 0
			R = 1.5;
			r = .5;
			for (i= -hs; i<hs; i+=step){
				for (j = -hs; j<hs; j+=step){
					for (k = -hs; k<hs; k+=step){
						var vx:Number = rVerts[inc] ;
						inc++
						var vy:Number = rVerts[inc]  ;
						inc++
						var vz:Number=  rVerts[inc] ;
						inc++
						var s:Number = Math.pow(vx  * vx  + vy * vy + vz * vz + R*R - r * r, 2) - 4 * (R * R)*(vx * vx + vy * vy);
						if (s <0 && s> -.5){
							verts[vinc] = (i * 50);
							vinc++
							verts[vinc] = (j * 50);
							vinc++
							verts[vinc] = (k * 50);
							vinc++
							  inc += int((hs - k) / step) * 3;
							  k = hs;
						 }
					}
				}
			}
			canvas = new BitmapData(400,400,false, 0x000000);
			addChild(new Bitmap(canvas));
			render();
			

               }
               // private methods

		private function render():void{
			matrix.identity();
			matrix.appendTranslation(200, 200, 0);
			Utils3D.projectVectors(matrix, verts, pVerts, uvts);
			canvas.lock();
			canvas.fillRect(canvas.rect, 0x000000);
			var inc:int = 2;
			var c:int = 0;
			var r:Rectangle = new Rectangle();
			r.width = r.height = 2;
			for (var i:int = 0; i<pVerts.length; i+=2){
				  r.x = pVerts[i];
				  r.y = pVerts[i + 1];
				  c = Math.max(0,100 - verts[inc]);
				  canvas.fillRect(r, c <<16 | c <<8 | c);
				  inc += 3;
			}
			canvas.unlock();
		}
		

       }

}