/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xy6S
 */

// forked from bigeneral's SimpleScrollbar
package {
    
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldAutoSize;
    import flash.events.Event;
        
    [SWF(backgroundColor=0xf0f0f0, frameRate=100)]
    
    public class SimpleScrollbarDemo extends Sprite {
        
        private var container:Sprite;
        private var textField:TextField;
        private var container_mask:Sprite;
        private var scrollbar:SimpleScrollbar;
        
        public function SimpleScrollbarDemo() {
            addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            textField = new TextField();
            textField.defaultTextFormat = new TextFormat('Helvetica', 66, 0x3399ff);
            textField.autoSize = TextFieldAutoSize.LEFT;
            textField.selectable = false;
            textField.text = 'This is Brad.  ....See Brad run.  ....Run Brad, run! =D';
            
            container = new Sprite();
            container.graphics.beginFill(0xd0d0d0, 1);
            container.graphics.drawRect(0, 0, textField.width, stage.stageHeight - 20);
            container.graphics.endFill();
            
            textField.x = 0;
            textField.y = container.height / 2 - textField.height / 2;
            
            container.addChild(textField);
            addChild(container);
            
            container_mask = new Sprite();
            container_mask.graphics.beginFill(0x000000, 0.5);
            container_mask.graphics.drawRect(0, 0, stage.stageWidth, container.height);
            addChild(container_mask);
            
            container.mask = container_mask;
            
            scrollbar = new SimpleScrollbar(container, container_mask, 20, 0x000000, 0x515151);
            addChild(scrollbar);
            scrollbar.enable();
        }
        
    }
    
}

import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.utils.Timer;
import flash.utils.getTimer;
import flash.events.TimerEvent;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.KeyboardEvent;
internal class SimpleScrollbar extends Sprite {
    
    private var _content:DisplayObject;
    private var _contentArea:DisplayObject;
    private var _bar:Sprite;
    private var _barColor:uint;
    private var _track:Sprite;
    private var _trackColor:uint;
    private var _scrollbarWidth:Number;
    private var _contentXpos:Number;
    private var _contentYpos:Number;
    private var _ratio:Number;
    private var _dragArea:Rectangle;
    
    private var _scrollDir:String;
    private var _dragging:Boolean = false;
    
    private var dest:Point = new Point();
    private var twTime:Number = 0.5;
    
    public function SimpleScrollbar( target_mc:DisplayObject, content_area:DisplayObject, bar_width:Number, bar_color:uint, track_color:uint ) {
        visible = false;
        
        _content = target_mc;
        _contentArea = content_area;
        
        _scrollbarWidth = bar_width;
        
        _barColor = bar_color;
        _trackColor = track_color;
        
        _contentXpos = _content.x;
        _contentYpos = _content.y;
        
        if( _content.height > _contentAreaRect.height ) {
            _scrollDir = "vertical";
        } else if( _content.width > _contentAreaRect.width ) {
            _scrollDir = "horizontal";
        }
        
        if( _scrollDir == "vertical" ) {
            x = _content.x + _content.width;
            y = _content.y;
        } else if( _scrollDir == "horizontal" ) {
            x = _content.x;
            y = _content.y + _content.height;
        }
        
        addEventListener( Event.ADDED_TO_STAGE, init );
    }
    
    private function init( e:Event ):void {
        visible = true;
        
        removeEventListener( Event.ADDED_TO_STAGE, init );
        
        _track = new Sprite();
        _track.graphics.beginFill( _trackColor, 1 );
        if( _scrollDir == "vertical" ) {
            _track.graphics.drawRect( 0, 0, _scrollbarWidth, _contentAreaRect.height );
        } else if( _scrollDir == "horizontal" ) {
            _track.graphics.drawRect( 0, 0, _contentAreaRect.width, _scrollbarWidth );
        }
        
        _bar  = new Sprite();
        _bar.buttonMode = true;
        _bar.graphics.beginFill( _barColor, 1 );
        if( _scrollDir == "vertical" ) {
            var barHeight:Number = Math.floor( (_contentAreaRect.height / _content.height) * _track.height );
            _bar.graphics.drawRect( 0, 0, _scrollbarWidth, barHeight );
        } else if( _scrollDir == "horizontal" ) {
            var barWidth:Number = Math.floor( (_contentAreaRect.width / _content.width) * _track.width );
            _bar.graphics.drawRect( 0, 0, barWidth, _scrollbarWidth );
        }
        
        if( _scrollDir == "vertical" ) {
            _ratio = -( _content.height - _contentAreaRect.height ) / ( _track.height - _bar.height );
        } else if( _scrollDir == "horizontal" ) {
            _ratio = -( _content.width - _contentAreaRect.width ) / ( _track.width - _bar.width );
        }
        
        addChild( _track );
        addChild( _bar );
    }
    
    public function enable():void {
        _bar.addEventListener( MouseEvent.MOUSE_DOWN, enableDrag );
        stage.addEventListener( MouseEvent.MOUSE_WHEEL, onWheelHandler );
        stage.addEventListener( KeyboardEvent.KEY_DOWN, onKeyDownHandler );
        _track.addEventListener( MouseEvent.CLICK, onTrackClickHandler );
    }
    
    public function disable():void {
        _bar.removeEventListener( MouseEvent.MOUSE_DOWN, enableDrag );
        stage.removeEventListener( MouseEvent.MOUSE_WHEEL, onWheelHandler );
        stage.removeEventListener( KeyboardEvent.KEY_DOWN, onKeyDownHandler );
        _track.removeEventListener( MouseEvent.CLICK, onTrackClickHandler );
    }
    
    public function update():void {
        if( _scrollDir == "vertical" ) {
            _track.height = _contentAreaRect.height;
            _bar.height = ( _contentAreaRect.height / _content.height ) * _track.height;
            _ratio = -( _content.height - _contentAreaRect.height ) / ( _track.height - _bar.height );
        } else if( _scrollDir == "horizontal" ) {
            _track.width = _contentAreaRect.width;
            _bar.width = ( _contentAreaRect.width / _content.width ) * _track.width;
            _ratio = -( _content.width - _contentAreaRect.width ) / ( _track.width - _bar.width );
        }
        
        moveContent();
    }
    
    public function get dragging():Boolean {
        return _dragging;
    }
    
    private function get _contentAreaRect():Rectangle {
        return _contentArea.getRect( stage );
    }
    
    private function enableDrag( e:MouseEvent ):void {
        
        if( _scrollDir == "vertical" ) {
            _dragArea = new Rectangle( 0, 0, 0, _track.height - _bar.height );
            _bar.startDrag( false, _dragArea );
        } else if( _scrollDir == "horizontal" ) {
            _dragArea = new Rectangle( 0, 0, _track.width - _bar.width, 0 );
            _bar.startDrag( false, _dragArea );
        }
        
        _dragging = true;
        stage.addEventListener( MouseEvent.MOUSE_MOVE, onBarDragHandler );
        _bar.addEventListener( MouseEvent.MOUSE_UP, disableDrag );
        stage.addEventListener( MouseEvent.MOUSE_UP, disableDrag );
    }

    private function disableDrag( e:MouseEvent ):void {
        _bar.stopDrag();
        _dragging = false;
        stage.removeEventListener( MouseEvent.MOUSE_MOVE, onBarDragHandler );
        _bar.removeEventListener( MouseEvent.MOUSE_UP, disableDrag );
        stage.removeEventListener( MouseEvent.MOUSE_UP, disableDrag );
    }

    private function onBarDragHandler( e:MouseEvent ):void {
        e.updateAfterEvent();
        moveContent();
    }

    private function onWheelHandler( e:MouseEvent ):void {
        if(_contentAreaRect.contains( this.parent.mouseX, this.parent.mouseY )) {
            moveBar( _ratio * e.delta * 3 );
        }
    }
    
    private function onKeyDownHandler( e:KeyboardEvent ):void {
        if(_contentAreaRect.contains( this.parent.mouseX, this.parent.mouseY )) {
            if( _scrollDir == "vertical" ) {
                if( e.keyCode == 38 ) { //UpKey
                    moveBar( _ratio * 9 );
                } else if( e.keyCode == 40 ) { //DownKey
                    moveBar( -_ratio * 9 );
                }
            } else if( _scrollDir == "horizontal" ) {
                if( e.keyCode == 37 ) { //LeftKey
                    moveBar( _ratio * 9 );
                } else if( e.keyCode == 39 ) { //RightKey
                    moveBar( -_ratio * 9 );
                }
            }
        }
    }
    
    private function onTrackClickHandler( e:MouseEvent ):void {
        if( _scrollDir == "vertical" ) {
            if( _track.mouseY < _bar.y ) {
                moveBar( ( _track.mouseY - _bar.y ) );
            } else if( _track.mouseY > ( _bar.y + _bar.height ) ) {
                moveBar( ( _track.mouseY - ( _bar.y + _bar.height ) ) );
            }
        } else if( _scrollDir == "horizontal" ) {
            if( _track.mouseX < _bar.x ) {
                moveBar( ( _track.mouseX - _bar.x ) );
            } else if( _track.mouseX > ( _bar.x + _bar.width ) ) {
                moveBar( ( _track.mouseX - ( _bar.x + _bar.width ) ) );
            }
        }
    }
    
    private function moveBar( _move:Number ):void {
        if( _scrollDir == "vertical" ) {
            _bar.y += _move;
            if( _bar.y > ( _contentAreaRect.height - _bar.height ) ) {
                _bar.y = _contentAreaRect.height - _bar.height;
            } else if( _bar.y < 0 ) {
                _bar.y = 0;
            }
        } else if( _scrollDir == "horizontal" ) {
            _bar.x += _move;
            if( _bar.x > ( _contentAreaRect.width - _bar.width ) ) {
                _bar.x = _contentAreaRect.width - _bar.width;
            } else if( _bar.x < 0 ) {
                _bar.x = 0;
            }
        }
        moveContent();
    }
    
    private function moveContent():void {
        stage.addEventListener( Event.ENTER_FRAME, DoTween );
    }
    
    private function DoTween( e:Event /* e:TimerEvent*/ ):void {
        if( _scrollDir == "vertical" ) {
            dest.y = _ratio * _bar.y + _contentYpos;
            _content.y += ( dest.y - _content.y ) / getFriction();
            if( Math.abs( dest.y - _content.y ) < 0.1 ) {
                stage.removeEventListener( Event.ENTER_FRAME, DoTween );
                _content.y = dest.y;
            }
        } else if( _scrollDir == "horizontal" ) {
            dest.x = _ratio * _bar.x + _contentXpos;
            _content.x += ( dest.x - _content.x ) / getFriction();
            if( Math.abs( dest.x - _content.x ) < 0.1 ) {
                stage.removeEventListener( Event.ENTER_FRAME, DoTween );
                _content.x = dest.x;
            }
        }
    }
    
    private function getFriction():Number {
        var fric:Number = stage.frameRate / 6;
        if( _scrollDir == "vertical" ) {
            if( Math.abs( dest.y - _content.y ) < 1 ) {
                fric = 1;
            }
        } else if( _scrollDir == "horizontal" ) {
            if( Math.abs( dest.x - _content.x ) < 1 ) {
                fric = 1;
            }
        }
        return fric;
    }
    
}