/**
 * Copyright hi.kurosawa ( http://wonderfl.net/user/hi.kurosawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xxuQ
 */

package {
    //------------------------------------------
    //SWFファイル読み込みのテスト用
    //　URL指定
    // URL:http://programmingatelier.net/
    //------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.text.TextFieldAutoSize;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.IOErrorEvent;
    import flash.net.FileReference;
    import flash.display.Loader;
    import flash.net.URLLoader;
    import flash.net.FileFilter;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.system.Security;
    
    public class UrlLoadTest extends Sprite { 
        private var txtUrlXml:TextField;
        private var txtUrlSwf:TextField;
        private var txtToSwf:TextField;
        private var txtFromSwf:TextField;
        private var ladSwf:Loader;
        private var spSwf:Sprite;
        private var objSwf:Object = null;
        private var urlLoader:URLLoader;
        
        public function UrlLoadTest():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //画面作成
            var y0:int = 5;
            addChild(fncText(5, y0, 400, 20, "外部サーバのSWFの読み込み")); y0 += 25;
            addChild(fncText(10, y0, 400, 20, "crossdomain.xmlのURL")); y0 += 20;
            txtUrlXml = fncTextInput(10, y0, 400, 20, 
                    "http://programmingatelier.net/publicSwf/crossdomain.xml");
            addChild(txtUrlXml);y0 += 25;
            addChild(fncText(10, y0, 400, 20, "読む込みswfのURL")); y0 += 20;
            txtUrlSwf = fncTextInput(10, y0, 400, 20, 
                    "http://programmingatelier.net/publicSwf/test/LoadTest.swf");
            addChild(txtUrlSwf);y0 += 25;
            addChild(fncTextButton(10, y0, 100, 20, "SWF読む込み", fncLoadSwf));y0 += 25;

            addChild(fncText(10, y0, 400, 20, "読み込んだSWFに送るデータ")); y0 += 20;
            txtToSwf = fncTextInput(10, y0, 400, 20, 
                    "読み込んだSWFに送るデータ");
            addChild(txtToSwf);y0 += 25;
            addChild(fncText(10, y0, 400, 20, "読み込んだSWFから受け取るデータ")); y0 += 20;
            txtFromSwf = fncTextInput(10, y0, 400, 20, "");
            addChild(txtFromSwf);y0 += 25;

            addChild(fncTextButton(10, y0, 200, 20, "読み込んだSWFの関数実行", fncLoadFunc));
            y0 += 25;
            addChild(fncText(10, y0, 400, 20, "読み込んだSWFを表示するエリア")); y0 += 20;
            spSwf = new Sprite();
            spSwf.x = 5;
            spSwf.y = y0;
            addChild(spSwf);
        }
        //外部サーバのSWFの読み込み
        private function fncLoadSwf(e:MouseEvent):void {
            if (txtUrlXml.text == "" || txtUrlSwf.text == "") { return;}
            Security.loadPolicyFile(txtUrlXml.text);
            urlLoader = new URLLoader();
            urlLoader.dataFormat = URLLoaderDataFormat.BINARY;
            urlLoader.addEventListener(Event.COMPLETE, onCompUrlLoad);
            urlLoader.load(new URLRequest(txtUrlSwf.text));
        }
        private function onCompUrlLoad(event:Event):void {
            ladSwf = new Loader;
            ladSwf.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadComplete);
            ladSwf.loadBytes(urlLoader.data);
        }
        private function onLoadComplete(e:Event):void {
            while (spSwf.numChildren) spSwf.removeChildAt(0);
            spSwf.addChild(ladSwf);
            objSwf = ladSwf.content as Object;
        }
        //読み込んだSWFの関数実行
        private function fncLoadFunc(e:MouseEvent):void {
            if (objSwf == null) { return; }
            txtFromSwf.text=objSwf.fncTest(txtToSwf.text);
        }
        //TextFieldをボタンのように使う
        public function fncTextButton(x:int, y:int, w:int, h:int, 
                    strText:String, fnc:Function):TextField {
            var txtFil:TextField = new TextField();
            txtFil.addEventListener(MouseEvent.CLICK, fnc);
            txtFil.x = x;
            txtFil.y = y;
            txtFil.width = w;
            txtFil.height = h;
            txtFil.border = true;
            txtFil.text = strText;
            txtFil.background = true;
            txtFil.backgroundColor = 0xeeeeee;
            return txtFil;
        }
        //文字の表示エリア
        public function  fncText(x:int, y:int, w:int, h:int, 
                    strText:String):TextField {
            var txtFil:TextField = new TextField();
            txtFil.x = x;
            txtFil.y = y;
            txtFil.width = w;
            txtFil.height = h;
            txtFil.text = strText;
            return txtFil;
        }
        //入力エリア
        public function  fncTextInput(x:int, y:int, w:int, h:int, 
                    strText:String):TextField {
            var txtInput:TextField = new TextField();
            txtInput.type = TextFieldType.INPUT;
            txtInput.x = x;
            txtInput.y = y;
            txtInput.width = w;
            txtInput.height = h;
            txtInput.border = true;
            txtInput.text = strText;
            return txtInput;
        }
    }
}