/**
 * Copyright esabear ( http://wonderfl.net/user/esabear )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xwCL
 */

// forked from JohnBrookes's MovieMaterial mouse test
// blue button turns red button on and off
package
{
    import flash.display.Bitmap;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    
    import gs.TweenMax;
    import org.papervision3d.materials.MovieMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;
    
    public class PVtestMoviematerial extends BasicView
    {
        private var p:Plane;
        private var blueButton:MovieClip;
        private var sp:Sprite;
        private var material:MovieMaterial;
        private var tween:Boolean;
        private var redButton:MovieClip;
        public function PVtestMoviematerial():void
        {
            init();
            //createMC();
    
            addEventListener(Event.ENTER_FRAME, tick);
        }
        
        
        private function changeColor(e:MouseEvent):void 
        {
            TweenMax.to(e.target, 1, { tint:tween ? 0x0000ff:0x00ff00, onComplete:doIt} );
            tween = tween == false;
        }
        
        private function doIt():void
        {
            if (tween)
            {
                redButton.addEventListener(MouseEvent.CLICK, changeScale);
                redButton.addEventListener(MouseEvent.ROLL_OVER, enable_buttonMode);
                redButton.addEventListener(MouseEvent.ROLL_OUT, disable_buttonMode);
            }
            else
            {
                redButton.removeEventListener(MouseEvent.CLICK, changeScale);
                redButton.removeEventListener(MouseEvent.ROLL_OVER, enable_buttonMode);
                redButton.removeEventListener(MouseEvent.ROLL_OUT, disable_buttonMode);
            }
        }
        
        private function changeScale(e:MouseEvent):void 
        {
            TweenMax.to(e.target, 1, {x: "30", onComplete:doIt} );
        }
        
        private function enable_buttonMode(e:MouseEvent):void
        {
            viewport.buttonMode = true;
        }
        private function disable_buttonMode(e:MouseEvent):void
        {
            viewport.buttonMode = false;
        }
        
        private function init():void
        {
            viewport.interactive = true;
            
            sp = new Sprite();
            sp.graphics.beginFill(0xCCCCCC);
            sp.graphics.drawRoundRect(0, 0, 500, 500, 30, 30);
            sp.graphics.endFill();
            
            
            blueButton = new MovieClip();
            blueButton.graphics.beginFill(0x0000ff);
            blueButton.graphics.drawRoundRect(sp.width*.5 - 110, sp.height*.5 - 190*.5 , 100, 190, 17, 17);
            blueButton.graphics.endFill();
            sp.addChild(blueButton);
            blueButton.addEventListener(MouseEvent.CLICK, changeColor);
            blueButton.addEventListener(MouseEvent.ROLL_OVER, enable_buttonMode);
            blueButton.addEventListener(MouseEvent.ROLL_OUT, disable_buttonMode);
            
            redButton = new MovieClip();
            redButton.graphics.beginFill(0xff0000);
            redButton.graphics.drawRoundRect(sp.width*.5 +10, sp.height*.5 - 190*.5, 100, 190, 17, 17);
            redButton.graphics.endFill();
            sp.addChild(redButton);

            material = new MovieMaterial(sp,true,true,true, new Rectangle(0,0,500,500));
            material.doubleSided = true;
            material.interactive = true;
            
            p = new Plane(material);
            scene.addChild(p);
            
        }
        
        private function tick(e:Event):void 
        {
            p.yaw(.8);
            singleRender();
        }
    }
}