/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xv7m
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    
    import frocessing.color.ColorHSV;
    
    [SWF(width = "465", height = "465")]
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        private var _canvas:BitmapData;
        private var _rings:/*Ring*/Array;
        private var _sprite:Sprite;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            graphics.beginFill( 0 );
            graphics.drawRect( 0, 0, stage.stageWidth, stage.stageHeight );
            graphics.endFill();
            
            var centerx:Number = stage.stageWidth / 2;
            var centery:Number = stage.stageHeight / 2;
            
            
            _sprite = new Sprite();
            _rings = new Array();
            
            var inum:int = 20;
            var jnum:int = 10;
            
            for ( var i:int = 0; i < inum; i++ )
            {
                for ( var j:int = 0; j < jnum; j++ )
                {
                    var ring:Ring = new Ring( centerx, centery, 10 + i * 15, (i * 10) + (360/jnum) * j, (i+1) * 0.05, (1/inum)*(i+4));
                    _rings[_rings.length] = ring;
                    _sprite.addChild( ring.shape );
                }
            }
            
            _canvas = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
            addChild( new Bitmap( _canvas ) );
            
            addEventListener( Event.ENTER_FRAME, Update );
        }
        
        private function Update(e:Event) : void
        {
            var ringnum:int = _rings.length;
            for ( var i:int = 0; i < ringnum; i++ )
            {
                _rings[i].Update(stage.mouseX,stage.mouseY);
            }
            
            _canvas.lock();
        //    _canvas.fillRect( _canvas.rect, 0 );
            _canvas.applyFilter( _canvas, _canvas.rect, new Point(), new BlurFilter(3,3,5) );
            _canvas.draw( _sprite );
            _canvas.unlock();
            
        }
        
    }
    
}
import flash.display.Shape;
import flash.geom.ColorTransform;
import frocessing.color.ColorHSV;
import flash.filters.BlurFilter;

class Ring {
    private var _shape:Shape;
    public    function get shape():Shape { return    _shape;    }
    
    private var _centerx:Number;
    private var _centery:Number;
    private var _angle:Number;
    private var _radius:Number;
    private var _rotspeed:Number;
    private var _alpha:Number;
    
    private var _shapeR:Number;
    private var _shapeRotSpeed:Number;
    
    private var _colorOfs:Number;
    private var _scaleOfs:Number;
    
    public    function    Ring(__centerx:Number,__centery:Number,__radius:Number, __angle:Number, __rotspeed:Number, __alpha:Number) {
        
        _centerx = __centerx;
        _centery = __centery;
        _angle = __angle;
        _radius = __radius;
        _rotspeed = __rotspeed;
        _alpha = __alpha;
        _scaleOfs = 0;
        
        var color:ColorHSV = new ColorHSV();
        color.h = int(Math.random() * 360);
        color.s = 0.3;
        _colorOfs = 0;
        
        _shape = new Shape();
        _shape.graphics.beginFill(color.value);
        _shapeR = __radius / 4;
        for ( var i:int = 0; i < 10; i++ )
        {
            var sx:Number = Math.cos( i * (360 / 10) * Math.PI / 180 ) * _shapeR;
            var sy:Number = Math.sin( i * (360 / 10) * Math.PI / 180 ) * _shapeR;
            _shape.graphics.drawCircle(sx, sy, 2);
        }
        _shape.graphics.endFill();
        
        _shape.x = _centerx + Math.cos( _angle * Math.PI / 180 ) * _radius;
        _shape.y = _centery + Math.sin( _angle * Math.PI / 180 ) * _radius;
        
        _shapeRotSpeed = 0;
    }
    
    public    function    Update(tx:Number, ty:Number) : void
    {
        _angle = (_angle + _rotspeed) % 360;
        
        _shape.x = _centerx + Math.cos( _angle * Math.PI / 180 ) * _radius;
        _shape.y = _centery + Math.sin( _angle * Math.PI / 180 ) * _radius;
        
        
        var power:Number = 0;
        var len:Number = (_shape.x - tx) * (_shape.x - tx) + (_shape.y - ty) * (_shape.y - ty);
        if ( len < _shapeR * _shapeR )
        {
            power = 1 - (len / (_shapeR * _shapeR));
            power *= 5;
        }
        _shapeRotSpeed += power;
        _shapeRotSpeed *= 0.9;
        
        _shape.rotation -= _shapeRotSpeed;
        
        
        if ( power != 0 )
        {
            _scaleOfs += 0.1;
            if ( _scaleOfs > 2 )    _scaleOfs = 2;
            
            _colorOfs += 30;
            if ( _colorOfs > 255 )    _colorOfs = 255;
        }
        _shape.scaleX = 1 + _scaleOfs;
        _shape.scaleY = 1 + _scaleOfs;
        _shape.transform.colorTransform = new ColorTransform(1, 1, 1, _alpha, _colorOfs, _colorOfs, _colorOfs);
        
        _scaleOfs *= 0.8;
        _colorOfs *= 0.8;
    }
}

