/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xud6
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    [SWF(frameRate = 60, width = 1024, height = 768)]
    public class Main extends Sprite
    {
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            addChild(new OrientationDebug);
            
            init();
        }
        
        public function init() :void
        {
            graphics.clear();
            graphics.lineStyle(1, 0);
            graphics.drawRect(0, 0, 1023, 767);
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class OrientationDebug extends Sprite
{
    public static var STAGE_WIDTH:int = 1024;
    public static var STAGE_HEIGHT:int = 768;
    
    private var debugOutput:Output = new Output("");
    
    private var bMouse:Boolean;
    private var initialMouse:Point = new Point();
    private var currentMouse:Point = new Point();
    private var calcMouse:Point = new Point();
    
    public function OrientationDebug()
    {
        bMouse = false;
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        addEventListener(Event.RESIZE, onResize);
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        init();
        
        addChild(new Button());
        addChild(debugOutput);
        
        stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
    
    public function onResize($e:*) :void
    {
        STAGE_WIDTH = $e.eventWidth;
        STAGE_HEIGHT = $e.eventHeight;
    }
    
    public function init() :void
    {
        graphics.clear();
        graphics.beginFill(0, 0.25);
        graphics.drawRect(0, 0, 1023, 767);
        graphics.endFill();
        graphics.lineStyle(1, 0, 0.15);

        initDimensionsX();
        initDimensionsY();

        if (bMouse)
        {
            var parseInit:Point = parseDimensions(initialMouse);
           // var parseCalc:Point = parseDimensions(calcMouse);
            
           // graphics.lineStyle(5, 0, 0.95);
            //graphics.drawRect(parseInit.x, parseInit.y, parseCalc.x, parseCalc.y);
        }
    }
    
    public function initDimensionsX() :void
    {
        for (var $x:Number = 0.05; $x < 0.96; $x+=0.05)
        {
            graphics.moveTo((STAGE_WIDTH * $x), (STAGE_HEIGHT * 0.05))
            graphics.lineTo((STAGE_WIDTH * $x), (STAGE_HEIGHT * 0.95))
        }
    }
    
    public function initDimensionsY() :void
    {
        for (var $y:Number = 0.05; $y < 0.96; $y+=0.05)
        {
            graphics.moveTo((STAGE_WIDTH * 0.05), (STAGE_HEIGHT * $y))
            graphics.lineTo((STAGE_WIDTH * 0.95), (STAGE_HEIGHT * $y))
        }
    }
    
    public function parseDimensions($point:Point) :Point
    {
        var $Xmin:int = -1;
        var $Ymin:int = -1;
        var $Xarr1:Array = [];
        var $Xarr2:Array = [];
        var $Yarr1:Array = [];
        var $Yarr2:Array = [];
        var $Xsnap:Number = 0;
        var $Ysnap:Number = 0;

        for (var $x:Number = 0; $x < 1.01; $x += 0.05)
        {
            $Xarr1.push(Math.abs($point.x - $x));
            $Xarr2.push($x);
        }    

        for (var $y:Number = 0; $y < 1.01; $y += 0.05)
        {
            $Yarr1.push(Math.abs($point.y - $y));
            $Yarr2.push($y);
        }

        $Xmin = Math.min.apply(null, $Xarr1);
        $Ymin = Math.min.apply(null, $Yarr1);

        for (var $x_:int = 0; $x_ < $Xarr1.length; $x_++)
        {
            if ($Xmin == $Xarr1[$x_])
               {$Xsnap = $Xarr2[$x_];
        }

        for (var $y_:int = 0; $y_ < $Yarr1.length; $y_++)
        {
            if ($Ymin == $Yarr1[$y_])
               {$Ysnap = $Yarr2[$y_]}
        }
        
        //debugOutput.content = "\n\n\n$Xsnap: " + $Xarr2[5] + "\n$Ysnap: " + $Yarr2[5];
        
        return new Point($Xarr2[10], $Yarr2[11]);
    }
    
    public function onMouseDown($e:MouseEvent) :void
    {
        currentMouse = initialMouse = new Point($e.stageX, $e.stageY);
        calcMouse = currentMouse.subtract(initialMouse);
        
        bMouse = true;
        
        init();
        
        stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
    }
    
    public function onMouseMove($e:MouseEvent) :void
    {
        currentMouse = new Point($e.stageX, $e.stageY);
        calcMouse = currentMouse.subtract(initialMouse);
                
        //debugOutput.content = "\n\n\n$X: " + currentMouse.x + "\n$Y: " + currentMouse.y;
                
        init();
    }
    
    public function onMouseUp($e:MouseEvent) :void
    {
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        
        bMouse = false;
    }
}

class Button extends Sprite
{
    protected var _x:Number;
    protected var _y:Number;
    protected var _alpha:Number;
    
    public function Button($x:Number = 5, $y:Number = 5, $alpha:Number = 0.5)
    {
        _x = $x;
        _y = $y;
        _alpha = $alpha;
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        init();
        
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
    }
    
    public function init() :void
    {
        graphics.clear();
        graphics.lineStyle(1, 0, 0.75);
        graphics.beginFill(0, _alpha);
        graphics.drawRect(_x, _y, 80, 20);
        graphics.endFill();
    }
    
    public function onMouseOver($e:MouseEvent) :void
    {
        alpha = 0.25;
        
        addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
    }
    
    public function onMouseOut($e:MouseEvent) :void
    {
        removeEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
        
        alpha = 0.5;
    }
    
    public function onMouseDown($e:MouseEvent) :void
    {
        alpha = 0;
        
        stage.stageWidth = 768;
        stage.stageHeight = 1024;
        
        stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
    }
    
    public function onMouseUp($e:MouseEvent) :void
    {
        stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        
        alpha = 0.5;
    }
    
    public override function get x() :Number
    { return _x }
    public override function get y() :Number
    { return _y }
    public override function get alpha() :Number
    { return _alpha }
    
    public override function set x($:Number) :void
    { _x = $; init() }
    public override function set y($:Number) :void
    { _y = $; init() }
    public override function set alpha($:Number) :void
    { _alpha = $; init() }
}    

class Output extends TextField
{
    private var textFormat :TextFormat;
        
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _content :String;
        
    public function Output($content:String, $x:Number = 1, $y:Number = 0, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = $x;
        _y = $y;
        _font = $font;
        _content = $content;
            
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
        
    public function init() :void
    {
        x = _x;
        y = _y;
        text = _content;
        
        textFormat = new TextFormat(_font);
        setTextFormat(textFormat);
    }
        
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        init(); 
    }
        
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
        
    public function set font($:String) :void
    { _font = $; init() }
    public function set content($:String) :void
    { _content = $; init() }
}